/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.tcp;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.ros.address.AdvertiseAddress;
import org.ros.address.BindAddress;
import org.ros.internal.node.service.ServiceManager;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.internal.transport.tcp.TcpServerPipelineFactory;

public class TcpRosServer {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(TcpRosServer.class);
    private final BindAddress bindAddress;
    private final AdvertiseAddress advertiseAddress;
    private final TopicParticipantManager topicParticipantManager;
    private final ServiceManager serviceManager;
    private final ScheduledExecutorService executorService;
    private ChannelFactory channelFactory;
    private ServerBootstrap bootstrap;
    private Channel outgoingChannel;
    private ChannelGroup incomingChannelGroup;

    public TcpRosServer(BindAddress bindAddress, AdvertiseAddress advertiseAddress, TopicParticipantManager topicParticipantManager, ServiceManager serviceManager, ScheduledExecutorService executorService) {
        this.bindAddress = bindAddress;
        this.advertiseAddress = advertiseAddress;
        this.topicParticipantManager = topicParticipantManager;
        this.serviceManager = serviceManager;
        this.executorService = executorService;
    }

    public void start() {
        Preconditions.checkState((this.outgoingChannel == null ? 1 : 0) != 0);
        this.channelFactory = new NioServerSocketChannelFactory((Executor)this.executorService, (Executor)this.executorService);
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        this.bootstrap.setOption("child.bufferFactory", (Object)new HeapChannelBufferFactory(ByteOrder.LITTLE_ENDIAN));
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.incomingChannelGroup = new DefaultChannelGroup();
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new TcpServerPipelineFactory(this.incomingChannelGroup, this.topicParticipantManager, this.serviceManager));
        this.outgoingChannel = this.bootstrap.bind((SocketAddress)this.bindAddress.toInetSocketAddress());
        this.advertiseAddress.setPortCallable(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((InetSocketAddress)TcpRosServer.this.outgoingChannel.getLocalAddress()).getPort();
            }
        });
    }

    public void shutdown() {
        if (this.outgoingChannel != null) {
            this.outgoingChannel.close().awaitUninterruptibly();
        }
        this.incomingChannelGroup.close().awaitUninterruptibly();
        this.outgoingChannel = null;
    }

    public InetSocketAddress getAddress() {
        return this.advertiseAddress.toInetSocketAddress();
    }

    public AdvertiseAddress getAdvertiseAddress() {
        return this.advertiseAddress;
    }
}

