/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport.tcp;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.ros.internal.node.service.ServiceManager;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.internal.transport.tcp.ConnectionTrackingChannelPipelineFactory;
import org.ros.internal.transport.tcp.TcpServerHandshakeHandler;

public class TcpServerPipelineFactory
extends ConnectionTrackingChannelPipelineFactory {
    public static final String LENGTH_FIELD_BASED_FRAME_DECODER = "LengthFieldBasedFrameDecoder";
    public static final String LENGTH_FIELD_PREPENDER = "LengthFieldPrepender";
    public static final String HANDSHAKE_HANDLER = "HandshakeHandler";
    private final TopicParticipantManager topicParticipantManager;
    private final ServiceManager serviceManager;

    public TcpServerPipelineFactory(ChannelGroup channelGroup, TopicParticipantManager topicParticipantManager, ServiceManager serviceManager) {
        super(channelGroup);
        this.topicParticipantManager = topicParticipantManager;
        this.serviceManager = serviceManager;
    }

    @Override
    public ChannelPipeline getPipeline() {
        ChannelPipeline pipeline = super.getPipeline();
        pipeline.addLast(LENGTH_FIELD_PREPENDER, (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast(LENGTH_FIELD_BASED_FRAME_DECODER, (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
        pipeline.addLast(HANDSHAKE_HANDLER, (ChannelHandler)new TcpServerHandshakeHandler(this.topicParticipantManager, this.serviceManager));
        return pipeline;
    }
}

