/*
 * Decompiled with CFR 0.152.
 */
package org.ros.node.topic;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ros.internal.node.CountDownRegistrantListener;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.node.topic.Subscriber;
import org.ros.node.topic.SubscriberListener;

public class CountDownSubscriberListener<T>
extends CountDownRegistrantListener<Subscriber<T>>
implements SubscriberListener<T> {
    private final CountDownLatch shutdownLatch;
    private final CountDownLatch newPublisherLatch;

    public static <T> CountDownSubscriberListener<T> newDefault() {
        return CountDownSubscriberListener.newFromCounts(1, 1, 1, 1, 1);
    }

    public static <T> CountDownSubscriberListener<T> newFromCounts(int masterRegistrationSuccessCount, int masterRegistrationFailureCount, int masterUnregistrationSuccessCount, int masterUnregistrationFailureCount, int newSubscriberCount) {
        return new CountDownSubscriberListener<T>(new CountDownLatch(masterRegistrationSuccessCount), new CountDownLatch(masterRegistrationFailureCount), new CountDownLatch(masterUnregistrationSuccessCount), new CountDownLatch(masterUnregistrationFailureCount), new CountDownLatch(newSubscriberCount));
    }

    private CountDownSubscriberListener(CountDownLatch masterRegistrationSuccessLatch, CountDownLatch masterRegistrationFailureLatch, CountDownLatch masterUnregistrationSuccessLatch, CountDownLatch masterUnregistrationFailureLatch, CountDownLatch newPublisherLatch) {
        super(masterRegistrationSuccessLatch, masterRegistrationFailureLatch, masterUnregistrationSuccessLatch, masterUnregistrationFailureLatch);
        this.newPublisherLatch = newPublisherLatch;
        this.shutdownLatch = new CountDownLatch(1);
    }

    @Override
    public void onNewPublisher(Subscriber<T> subscriber, PublisherIdentifier publisherIdentifier) {
        this.newPublisherLatch.countDown();
    }

    @Override
    public void onShutdown(Subscriber<T> subscriber) {
        this.shutdownLatch.countDown();
    }

    public void awaitNewPublisher() throws InterruptedException {
        this.newPublisherLatch.await();
    }

    public boolean awaitNewPublisher(long timeout, TimeUnit unit) throws InterruptedException {
        return this.newPublisherLatch.await(timeout, unit);
    }

    public void awaitShutdown() throws InterruptedException {
        this.shutdownLatch.await();
    }

    public boolean awaitShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }
}

