/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.powersystems.SolarCellNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;

public class SolarCellNodeJME3Object
extends DefaultJME3SceneObject<SolarCellNode> {
    private Adapter adapter;
    private final AssetManager assetManager;
    private Geometry cellGeometry = null;
    private ColorRGBA cellColor = ColorRGBA.White;

    public SolarCellNodeJME3Object(SolarCellNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.cellGeometry = this.createCellPanelGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.cellGeometry);
        ((SolarCellNode)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.cellGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.cellGeometry);
        }
        this.cellGeometry = this.createCellPanelGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.cellGeometry);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.cellGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((SolarCellNode)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public void setColor(RGBA rgb) {
        this.cellColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (SolarCellNodeJME3Object.this.cellGeometry != null) {
                    SolarCellNodeJME3Object.this.cellGeometry.getMaterial().setColor("Color", SolarCellNodeJME3Object.this.cellColor.clone());
                }
                return null;
            }
        });
    }

    private Geometry createCellPanelGeometry() {
        Geometry geometry = new Geometry("Solar Cell Body", this.createSolarCellMesh());
        geometry.setMaterial(this.createCellMaterial());
        Quaternion q = new Quaternion();
        q.fromAngleAxis(0.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Mesh createSolarCellMesh() {
        float x = (float)(((SolarCellNode)this.getTopologyNode()).getLength() / 2.0);
        float y = (float)(((SolarCellNode)this.getTopologyNode()).getWidth() / 2.0);
        float z = 0.01f;
        Box box = new Box(x, y, z);
        box.setMode(Mesh.Mode.Lines);
        return box;
    }

    private Material createCellMaterial() {
        ColorRGBA color = this.cellColor.clone();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SolarCellNode) {
                        int featureId = msg.getFeatureID(SolarCellNode.class);
                        switch (featureId) {
                            case 8: 
                            case 9: {
                                SolarCellNodeJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

