/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.powersystems.SolarPanelNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;

public class SolarPanelNodeJME3Object
extends DefaultJME3SceneObject<SolarPanelNode> {
    private Adapter adapter;
    private final AssetManager assetManager;
    private Geometry panelGeometry = null;
    private ColorRGBA panelColor = ColorRGBA.White;

    public SolarPanelNodeJME3Object(SolarPanelNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.panelGeometry = this.createSolarPanelGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.panelGeometry);
        ((SolarPanelNode)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.panelGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.panelGeometry);
        }
        this.panelGeometry = this.createSolarPanelGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.panelGeometry);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.panelGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((SolarPanelNode)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public void setColor(RGBA rgb) {
        this.panelColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (SolarPanelNodeJME3Object.this.panelGeometry != null) {
                    SolarPanelNodeJME3Object.this.panelGeometry.getMaterial().setColor("Color", SolarPanelNodeJME3Object.this.panelColor.clone());
                }
                return null;
            }
        });
    }

    private Geometry createSolarPanelGeometry() {
        Geometry geometry = new Geometry("Solar Panel Body", this.createSolarPanelMesh());
        geometry.setMaterial(this.createCellMaterial());
        Quaternion q = new Quaternion();
        q.fromAngleAxis(0.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        geometry.setLocalRotation(q);
        return geometry;
    }

    private Mesh createSolarPanelMesh() {
        float x = (float)(((SolarPanelNode)this.getTopologyNode()).getLength() / 2.0);
        float y = (float)(((SolarPanelNode)this.getTopologyNode()).getWidth() / 2.0);
        float z = 0.01f;
        Box box = new Box(x, y, z);
        box.setMode(Mesh.Mode.Lines);
        return box;
    }

    private Material createCellMaterial() {
        ColorRGBA color = this.panelColor.clone();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    System.out.print(SolarPanelNodeJME3Object.this.getTopologyNode());
                    if (msg.getNotifier() instanceof SolarPanelNode) {
                        int featureId = msg.getFeatureID(SolarPanelNode.class);
                        switch (featureId) {
                            case 6: 
                            case 7: {
                                SolarPanelNodeJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

