/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Argument;
import org.eclipse.apogy.core.invocator.ArgumentsList;
import org.eclipse.apogy.core.invocator.EClassArgument;
import org.eclipse.apogy.core.invocator.EDataTypeArgument;
import org.eclipse.apogy.core.invocator.EEnumArgument;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class ArgumentsListComposite
extends EMFFormsEListComposite<AbstractOperationCall, ArgumentsList, Argument> {
    private static final int NAME_COL_MIN_WIDTH = 250;
    private static final int VALUE_COL_MIN_WIDTH = 150;
    private static final int UNITS_COL_MIN_WIDTH = 50;
    private Adapter tempAdapter;

    public ArgumentsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.ABSTRACT_OPERATION_CALL__ARGUMENTS_LIST}), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS, settings);
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    private Adapter getAdapter() {
        if (this.tempAdapter == null) {
            this.tempAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AbstractOperationCall op = (AbstractOperationCall)ArgumentsListComposite.this.getRootEObject();
                    ArgumentsListComposite.this.setRootEObject(null);
                    ArgumentsListComposite.this.setRootEObject((EObject)op);
                }
            };
        }
        return this.tempAdapter;
    }

    protected void rootEObjectChanged(AbstractOperationCall rootEObject) {
        if (rootEObject != null && !rootEObject.eAdapters().contains((Object)this.getAdapter())) {
            rootEObject.eAdapters().add((Object)this.getAdapter());
            if (rootEObject.getArgumentsList() != null && !rootEObject.getArgumentsList().getArguments().isEmpty()) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(rootEObject.getArgumentsList().getArguments().get(0)));
            }
        }
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Argument argument = (Argument)element;
                String text = argument.getEParameter().getName();
                return text == null || text.length() == 0 ? "" : text;
            }

            public String getToolTipText(Object element) {
                Argument argument = (Argument)element;
                String text = ApogyCommonEMFFacade.INSTANCE.getDocumentation(argument.getEParameter());
                return text == null || text.length() == 0 ? null : text;
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)250);
        TreeViewerColumn valueColumn = new TreeViewerColumn(viewer, 0);
        valueColumn.getColumn().setText("Value");
        valueColumn.getColumn().setAlignment(0x1000000);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Argument argument = (Argument)element;
                if (argument instanceof EDataTypeArgument) {
                    EDataTypeArgument eDataTypeArgument = (EDataTypeArgument)argument;
                    String text = eDataTypeArgument.getValue();
                    return text == null || text.length() == 0 ? "" : text;
                }
                if (argument instanceof EEnumArgument) {
                    EEnumArgument eenumArgument = (EEnumArgument)argument;
                    String text = "";
                    text = eenumArgument.getEEnumLiteral() != null ? eenumArgument.getEEnumLiteral().getLiteral() : "?";
                    return text == null || text.length() == 0 ? "" : text;
                }
                if (argument instanceof EClassArgument) {
                    EClassArgument eClassArgument = (EClassArgument)argument;
                    String text = eClassArgument.getEParameter().getEType().getName();
                    return text == null || text.length() == 0 ? "" : text;
                }
                return "?";
            }
        });
        valueColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        TreeViewerColumn unitsColumn = new TreeViewerColumn(viewer, 0);
        unitsColumn.getColumn().setText("Units");
        unitsColumn.getColumn().setAlignment(0x1000000);
        unitsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Argument argument = (Argument)element;
                String units = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnitsAsString((ETypedElement)argument.getEParameter());
                return units == null || units.length() == 0 ? "" : units;
            }
        });
        unitsColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)50);
    }
}

