/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.InitialConditions;
import org.eclipse.apogy.core.invocator.InitialConditionsList;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialConditionsListComposite
extends EMFFormsEListComposite<InvocatorSession, InitialConditionsList, InitialConditions> {
    private static final Logger Logger = LoggerFactory.getLogger(InitialConditionsListComposite.class);

    public InitialConditionsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__INITIAL_CONDITIONS_LIST}), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS_LIST__INITIAL_CONDITIONS, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createCollectButton(parent, style);
        this.createApplyButton(parent, style);
    }

    protected Button createCollectButton(Composite parent, int style) {
        Button btnCollect = InitialConditionsListComposite.createButton((Composite)parent, (int)0, (String)"Collect", (Listener)new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)InitialConditionsListComposite.this.getDisplay(), () -> InitialConditionsListComposite.this.doCollect());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                InitialConditionsListComposite.this.refreshViewer();
            }
        });
        this.createCollectButtonBindings(btnCollect);
        return btnCollect;
    }

    protected void createCollectButtonBindings(Button button) {
        IObservableValue sessionStartDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_CREATION_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IObservableValue sessionDisposeDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_DISPOSAL_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IViewerObservableValue selectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ArrayList<Object> valesToWatch = new ArrayList<Object>();
        valesToWatch.add(sessionStartDate);
        valesToWatch.add(sessionDisposeDate);
        valesToWatch.add(selectionObservableValue);
        ISWTObservableValue buttonEnabledObservableValue = WidgetProperties.enabled().observe((Widget)button);
        for (IObservableValue iObservableValue : valesToWatch) {
            this.getDataBindingContext().bindValue((IObservableValue)buttonEnabledObservableValue, iObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(Object.class, Boolean.class, o -> {
                if (o != null) {
                    Context activeContext = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext();
                    if (activeContext != null) {
                        Date startDate = activeContext.getInstancesCreationDate();
                        Date disposeDate = activeContext.getInstancesDisposalDate();
                        if (startDate != null && disposeDate == null) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            })));
        }
    }

    protected void doCollect() {
        InitialConditions selectedInitialConditions = (InitialConditions)this.getSelectedItemObjects().get(0);
        try {
            ApogyCoreInvocatorFacade.INSTANCE.collectInitialConditions(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment(), selectedInitialConditions);
            MessageBox messageBox = new MessageBox(this.getShell());
            messageBox.setMessage("Sucessfuly collected Initial Conditions <" + selectedInitialConditions.getName() + ">.");
            messageBox.setText("Collect Initial Conditions");
            messageBox.open();
        }
        catch (Throwable t) {
            String errorMessage = "Failed to collect Initial Conditions <" + selectedInitialConditions.getName() + ">. See log for details.";
            Status errorStatus = new Status(4, "org.eclipse.apogy.core.invocator.ui", errorMessage);
            ErrorDialog.openError(null, (String)"Collect Initial Conditions", (String)errorMessage, (IStatus)errorStatus);
            Logger.error(t.getMessage(), t);
        }
    }

    protected Button createApplyButton(Composite parent, int style) {
        Button btnApply = InitialConditionsListComposite.createButton((Composite)parent, (int)0, (String)"Apply", (Listener)new Listener(){

            public void handleEvent(Event event) {
                BusyIndicator.showWhile((Display)InitialConditionsListComposite.this.getDisplay(), () -> InitialConditionsListComposite.this.doApply());
                InitialConditionsListComposite.this.refreshViewer();
            }
        });
        this.createApplyButtonBindings(btnApply);
        return btnApply;
    }

    protected void createApplyButtonBindings(Button button) {
        IObservableValue sessionStartDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_CREATION_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IObservableValue sessionDisposeDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_DISPOSAL_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IViewerObservableValue selectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ArrayList<Object> valesToWatch = new ArrayList<Object>();
        valesToWatch.add(sessionStartDate);
        valesToWatch.add(sessionDisposeDate);
        valesToWatch.add(selectionObservableValue);
        ISWTObservableValue buttonEnabledObservableValue = WidgetProperties.enabled().observe((Widget)button);
        for (IObservableValue iObservableValue : valesToWatch) {
            this.getDataBindingContext().bindValue((IObservableValue)buttonEnabledObservableValue, iObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(Object.class, Boolean.class, o -> {
                if (o != null) {
                    Context activeContext = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext();
                    if (activeContext != null) {
                        Date startDate = activeContext.getInstancesCreationDate();
                        Date disposeDate = activeContext.getInstancesDisposalDate();
                        if (startDate != null && disposeDate == null) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            })));
        }
    }

    protected void doApply() {
        final InitialConditions selectedInitialConditions = (InitialConditions)this.getSelectedItemObjects().get(0);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ApogyCoreInvocatorFacade.INSTANCE.applyInitialConditions(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment(), selectedInitialConditions, monitor);
                }
                catch (Throwable t) {
                    String errorMessage = "Failed to apply Initial Conditions<" + selectedInitialConditions.getName() + ">. See log for details.";
                    Status errorStatus = new Status(4, "org.eclipse.apogy.core.invocator.ui", errorMessage);
                    ErrorDialog.openError(null, (String)"Collect Initial Conditions", (String)errorMessage, (IStatus)errorStatus);
                    Logger.error(t.getMessage(), t);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }
}

