/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.handlers;

import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.ui.handlers.AbstractProgramRuntimeHandler;
import org.eclipse.apogy.core.invocator.ui.parts.IProgramPart;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeProgramRuntimeHandler
extends AbstractProgramRuntimeHandler {
    private static final Logger Logger = LoggerFactory.getLogger(ResumeProgramRuntimeHandler.class);

    @Execute
    public void execute(MPart part) {
        IProgramPart programPart = (IProgramPart)part.getObject();
        AbstractProgramRuntime runtime = programPart.getAbstractProgramRuntime();
        try {
            runtime.resume();
        }
        catch (Exception e) {
            String errorMessage = "Failed to Resume execution !";
            Logger.error(errorMessage, (Throwable)e);
            this.openErrorDialog(errorMessage);
        }
    }

    @Override
    @CanExecute
    public boolean canExecute(MPart part) {
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null) {
            return false;
        }
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList() == null) {
            return false;
        }
        if (part.getObject() instanceof IProgramPart) {
            IProgramPart programPart = (IProgramPart)part.getObject();
            AbstractProgramRuntime runtime = programPart.getAbstractProgramRuntime();
            if (runtime == null) {
                return false;
            }
            if (runtime.getState() == ProgramRuntimeState.SUSPENDED || runtime.getState() == ProgramRuntimeState.INITIALIZED) {
                return true;
            }
        }
        return false;
    }
}

