/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.handlers;

import javax.inject.Named;
import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ProgramRuntimeState;
import org.eclipse.apogy.core.invocator.ui.handlers.AbstractProgramRuntimeHandler;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunProgramRuntimeHandler
extends AbstractProgramRuntimeHandler {
    private static final Logger Logger = LoggerFactory.getLogger(RunProgramRuntimeHandler.class);

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.apogy.core.invocator.ui.commandparameter.stepByStep") String stepByStep, MPart part) {
        AbstractProgramRuntime runtime = this.getAbstractProgramRuntime(part);
        if (runtime != null) {
            try {
                runtime.init();
                runtime.resume();
                Logger.info("Program <" + runtime.getProgram().getName() + "> execution started.");
            }
            catch (Exception e) {
                String errorMessage = "Program Run Failed !";
                Logger.error(errorMessage, (Throwable)e);
                this.openErrorDialog(String.valueOf(errorMessage) + e.getMessage());
            }
        } else {
            String errorMessage = "Part <" + part.getLabel() + "> has no AbstractProgramRuntime set !";
            Logger.error(errorMessage);
            this.openErrorDialog(errorMessage);
        }
    }

    @Override
    @CanExecute
    public boolean canExecute(MPart part) {
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null) {
            return false;
        }
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getProgramRuntimesList() == null) {
            return false;
        }
        AbstractProgramRuntime runtime = this.getAbstractProgramRuntime(part);
        return runtime.getState() == ProgramRuntimeState.INITIALIZED || runtime.getState() == ProgramRuntimeState.NOT_INITIALIZED || runtime.getState() == ProgramRuntimeState.TERMINATED;
    }
}

