/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.utils;

import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationCallButtonManager {
    protected static final Logger Logger = LoggerFactory.getLogger(OperationCallButtonManager.class);
    public OperationCallResult operationCallResult = null;
    protected Button managedButton = null;
    protected boolean notifyOnCompletion = true;
    protected boolean confirmExecute = true;
    protected String operationDescription = null;

    public OperationCallButtonManager(Button managedButton, String operationDescription, boolean notifyOnCompletion) {
        this(managedButton, operationDescription, notifyOnCompletion, false);
    }

    public OperationCallButtonManager(final Button managedButton, final String operationDescription, final boolean confirmExecute, boolean notifyOnCompletion) {
        this.managedButton = managedButton;
        this.operationDescription = operationDescription;
        this.confirmExecute = confirmExecute;
        this.notifyOnCompletion = notifyOnCompletion;
        this.managedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean proceed = true;
                if (confirmExecute) {
                    proceed = MessageDialog.openConfirm((Shell)managedButton.getShell(), (String)"Confirm", (String)("Please confirm you want to do the following : \n\n" + operationDescription));
                }
                if (proceed) {
                    AbstractOperationCall operationCall = OperationCallButtonManager.this.createOperationCall();
                    if (operationCall == null) {
                        MessageDialog.openError((Shell)OperationCallButtonManager.this.managedButton.getDisplay().getActiveShell(), (String)("Error : " + operationDescription), (String)"The Operation created is null !");
                    } else {
                        OperationCallButtonManager.this.execute(operationCall);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    public OperationCallResult execute(final AbstractOperationCall operationCall) {
        Job job = new Job(this.operationDescription){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Logger.info("Launching execution of " + OperationCallButtonManager.this.operationDescription);
                    OperationCallButtonManager.this.operationCallResult = ApogyCoreInvocatorFacade.INSTANCE.exec(operationCall);
                    if (OperationCallButtonManager.this.operationCallResult.getExceptionContainer() != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    OperationCallButtonManager.this.postExecuteWithError((this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer().getException());
                                    String message = "The following error occured during " + (this).OperationCallButtonManager.this.operationDescription + " : \n" + (this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer().getException().toString();
                                    Logger.info(message, (this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer().getException());
                                    MessageDialog.openError((Shell)(this).OperationCallButtonManager.this.managedButton.getDisplay().getActiveShell(), (String)"Error : ", (String)message);
                                    (this).OperationCallButtonManager.this.managedButton.setEnabled(true);
                                }
                                catch (Exception e) {
                                    Logger.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    } else if (OperationCallButtonManager.this.notifyOnCompletion) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if ((this).OperationCallButtonManager.this.operationCallResult != null) {
                                        if ((this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer() == null) {
                                            OperationCallButtonManager.this.opsCallCompleted((this).OperationCallButtonManager.this.operationCallResult);
                                        } else if ((this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer().getException() != null) {
                                            OperationCallButtonManager.this.opsCallCompletedWithException((this).OperationCallButtonManager.this.operationCallResult);
                                        }
                                    }
                                    (this).OperationCallButtonManager.this.managedButton.setEnabled(true);
                                }
                                catch (Exception e) {
                                    Logger.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OperationCallButtonManager.this.postExecuteWithError(e);
                            String message = "The following error occured during " + (this).OperationCallButtonManager.this.operationDescription + " : \n" + e.toString();
                            Logger.info(message);
                            MessageDialog.openError((Shell)(this).OperationCallButtonManager.this.managedButton.getDisplay().getActiveShell(), (String)"Error", (String)message);
                            (this).OperationCallButtonManager.this.managedButton.setEnabled(true);
                        }
                    });
                }
                UIJob uiJob = new UIJob("Waiting for " + OperationCallButtonManager.this.operationDescription + " to complete."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!(this).OperationCallButtonManager.this.managedButton.isDisposed()) {
                            (this).OperationCallButtonManager.this.managedButton.setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
        return this.operationCallResult;
    }

    protected abstract AbstractOperationCall createOperationCall();

    protected void postExecuteWithError(Throwable t) {
    }

    protected void opsCallCompleted(OperationCallResult operationCallResult) {
        String message = String.valueOf(this.operationDescription) + " : Completed sucessfully.";
        Logger.info(message);
        MessageDialog.openInformation((Shell)this.managedButton.getDisplay().getActiveShell(), (String)(String.valueOf(this.operationDescription) + " Success"), (String)message);
    }

    protected void opsCallCompletedWithException(OperationCallResult operationCallResult) {
        String message = String.valueOf(this.operationDescription) + " : Completed with error : .";
        message = String.valueOf(message) + operationCallResult.getExceptionContainer().getException().getMessage();
        Logger.error(message);
        MessageDialog.openError((Shell)this.managedButton.getDisplay().getActiveShell(), (String)(String.valueOf(this.operationDescription) + " Complete with Error!"), (String)message);
    }
}

