/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.impl;

import java.util.HashMap;
import org.eclipse.apogy.addons.ros.ApogyAddonsROSFactory;
import org.eclipse.apogy.addons.ros.ROSPublisher;
import org.eclipse.apogy.addons.ros.impl.ROSPublisherManagerImpl;
import org.ros.internal.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSPublisherManagerCustomImpl
extends ROSPublisherManagerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ROSPublisherManagerImpl.class);
    public static int PUBLISHER_LAUNCH_MAX_TRIES = 5;

    @Override
    public HashMap<String, ROSPublisher<?>> getPublishers() {
        if (this.publishers == null) {
            this.publishers = new HashMap();
        }
        return this.publishers;
    }

    @Override
    public void createPublisher(String topicName, String messageType) {
        ROSPublisher publisher = ApogyAddonsROSFactory.eINSTANCE.createROSPublisher();
        publisher.setTopicName(topicName);
        publisher.setMessageType(messageType);
        this.getPublishers().put(topicName, publisher);
    }

    @Override
    public void launch() {
        for (ROSPublisher<?> publisher : this.getPublishers().values()) {
            try {
                publisher.launch(this.getNode());
            }
            catch (Exception exception) {}
        }
        this.setRunning(true);
    }

    @Override
    public void stop() {
        for (ROSPublisher<?> publisher : this.getPublishers().values()) {
            publisher.stop();
        }
    }

    @Override
    public <T extends Message> T createMessage(String topicName) {
        ROSPublisher<T> publisher = this.getPublisher(topicName);
        if (publisher != null) {
            return publisher.newMessage();
        }
        return null;
    }

    @Override
    public <T extends Message> void publish(String topicName, T message) {
        this.getPublisher(topicName).publish(message);
    }

    @Override
    public <T extends Message> ROSPublisher<T> getPublisher(String topicName) {
        if (this.getPublishers().containsKey(topicName)) {
            ROSPublisher<?> publisher = this.getPublishers().get(topicName);
            if (!publisher.isLaunched()) {
                int tries = 0;
                while (!publisher.isLaunched() && tries <= PUBLISHER_LAUNCH_MAX_TRIES) {
                    try {
                        publisher.launch(this.getNode());
                        ++tries;
                    }
                    catch (Exception exception) {
                        Logger.error("Could not launch Publisher <" + topicName + ">.");
                    }
                    if (publisher.isLaunched()) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return publisher;
        }
        return null;
    }
}

