/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.impl;

import org.eclipse.apogy.common.io.jinput.Activator;
import org.eclipse.apogy.common.io.jinput.EComponent;
import org.eclipse.apogy.common.io.jinput.EComponentQualifier;
import org.eclipse.apogy.core.programs.controllers.impl.ControllerStateTriggerImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerStateTriggerCustomImpl
extends ControllerStateTriggerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ControllerStateTriggerImpl.class);
    private boolean run = false;
    private Thread thread = null;

    @Override
    public void setRepeatPeriod(long newRepeatPeriod) {
        if (newRepeatPeriod == -1L) {
            this.stopThread();
        }
        super.setRepeatPeriod(newRepeatPeriod);
    }

    @Override
    public void setComponentQualifier(EComponentQualifier newComponentQualifier) {
        super.setComponentQualifier(newComponentQualifier);
        EComponent component = Activator.getEControllerEnvironment().resolveEComponent(newComponentQualifier);
        if (component != null) {
            boolean buttonStatus = this.convert(component.getPollData());
            this.update(!buttonStatus, buttonStatus);
        }
    }

    @Override
    public void stop() {
        this.stopThread();
        super.stop();
    }

    @Override
    protected boolean convert(float value) {
        return value != 0.0f;
    }

    protected void startThread() {
        String message = null;
        message = this.getName() != null ? String.valueOf(this.getName()) + " : is now Enabled." : "is now Enabled.";
        this.run = true;
        Logger.info(message);
        this.thread = new Thread(){

            @Override
            public void run() {
                while (ControllerStateTriggerCustomImpl.this.run) {
                    try {
                        ControllerStateTriggerCustomImpl.this.getOperationCallControllerBinding().update();
                        if (ControllerStateTriggerCustomImpl.this.getRepeatPeriod() >= 50L) {
                            Thread.sleep(ControllerStateTriggerCustomImpl.this.getRepeatPeriod());
                            continue;
                        }
                        Thread.sleep(50L);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
            }
        };
        this.thread.start();
    }

    protected void stopThread() {
        this.run = false;
        String message = null;
        message = this.getName() != null ? String.valueOf(this.getName()) + " : is now Disabled." : "is now Disabled.";
        Logger.info(message);
    }

    @Override
    protected void update(boolean oldValue, boolean newValue) {
        if (this.isStarted()) {
            if (newValue == this.isEnablingValue()) {
                this.startThread();
            } else {
                this.stopThread();
            }
        }
    }

    public EList<Adapter> eAdapters() {
        return super.eAdapters();
    }
}

