/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSPackage;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorClientProfile;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServiceID;
import org.eclipse.apogy.addons.mqtt.ros.ui.wizards.AbstractServiceSelectionWizardPage;
import org.eclipse.apogy.addons.mqtt.ros.ui.wizards.MQTTArbitratorClientServiceWizard;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MQTTROSArbitratorClientProfileComposite
extends EMFFormsEListComposite<MQTTROSArbitratorServer, MQTTROSArbitratorServer, MQTTROSArbitratorClientProfile> {
    public MQTTROSArbitratorClientProfileComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__USERS, settings);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return MQTTROSArbitratorClientProfileComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                if (object instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)object;
                    return server.getUsers().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object object) {
                return new Object[0];
            }
        };
    }

    protected void createButtons(Composite parent, int style) {
        this.createGrantServiceButton(parent, style);
        this.createRevokeServiceButton(parent, style);
        this.createSeparator(parent, style);
        this.createGrantExclusiveServiceButton(parent, style);
        this.createRevokeExclusiveServiceButton(parent, style);
        this.createSeparator(parent, style);
        this.createRevokeAllServiceButton(parent, style);
        this.createSeparator(parent, style);
        this.createAddClientButton(parent, style);
        this.createDeleteClientButton(parent, style);
        this.createSeparator(parent, style);
        this.createClearUserTokensButton(parent, style);
    }

    protected Button createGrantServiceButton(Composite parent, int style) {
        Button btn = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Grant...", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doGrantService(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createGrantServiceButtonBindings(btn);
        btn.setToolTipText("Opens a wizard to select Services to be granted to the selected user.");
        return btn;
    }

    protected void createGrantServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doGrantService(List<MQTTROSArbitratorClientProfile> list) {
        for (final MQTTROSArbitratorClientProfile user : list) {
            MQTTArbitratorClientServiceWizard wizard = new MQTTArbitratorClientServiceWizard((MQTTROSArbitratorServer)this.getRootEObject(), user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES, null){

                @Override
                protected AbstractServiceSelectionWizardPage createServiceSelectionWizardPage(MQTTROSArbitratorServer server, MQTTROSArbitratorClientProfile user2) {
                    return new AbstractServiceSelectionWizardPage(server, user2){

                        @Override
                        protected EStructuralFeature getUserProfileServicesFeature() {
                            return ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES;
                        }

                        @Override
                        protected List<MQTTROSArbitratorServiceID> getAvailableServices(MQTTROSArbitratorClientProfile profile) {
                            ArrayList<MQTTROSArbitratorServiceID> availableServices = new ArrayList<MQTTROSArbitratorServiceID>();
                            for (MQTTROSArbitratorServiceID service : this.server.getServices()) {
                                if (profile.getGrantedServices().contains((Object)service) || profile.getExclusivelyGrantedServices().contains((Object)service)) continue;
                                availableServices.add(service);
                            }
                            return availableServices;
                        }
                    };
                }

                @Override
                protected void processService(MQTTROSArbitratorServer server, MQTTROSArbitratorServiceID service) throws Exception {
                    if (!server.grantControl(user, service)) {
                        String message = "Failed to grant Service <" + service.getServiceName() + "> to User <" + user.getUserID() + "> !";
                        MessageDialog.openError((Shell)MQTTROSArbitratorClientProfileComposite.this.getShell(), (String)"Error", (String)message);
                    }
                }
            };
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
            this.refreshViewer();
        }
    }

    protected Button createRevokeServiceButton(Composite parent, int style) {
        Button btn = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Revoke...", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doRevokeService(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createRevokeServiceButtonBindings(btn);
        btn.setToolTipText("Opens a wizard to select Services to be revoked from the selected user.");
        return btn;
    }

    protected void createRevokeServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doRevokeService(List<MQTTROSArbitratorClientProfile> list) {
        for (final MQTTROSArbitratorClientProfile user : list) {
            MQTTArbitratorClientServiceWizard wizard = new MQTTArbitratorClientServiceWizard((MQTTROSArbitratorServer)this.getRootEObject(), user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES, null){

                @Override
                protected AbstractServiceSelectionWizardPage createServiceSelectionWizardPage(MQTTROSArbitratorServer server, MQTTROSArbitratorClientProfile user2) {
                    return new AbstractServiceSelectionWizardPage(server, user2){

                        @Override
                        protected EStructuralFeature getUserProfileServicesFeature() {
                            return ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES;
                        }

                        @Override
                        protected List<MQTTROSArbitratorServiceID> getAvailableServices(MQTTROSArbitratorClientProfile profile) {
                            ArrayList<MQTTROSArbitratorServiceID> availableServices = new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)profile.getGrantedServices());
                            return availableServices;
                        }
                    };
                }

                @Override
                protected void processService(MQTTROSArbitratorServer server, MQTTROSArbitratorServiceID service) throws Exception {
                    server.revokeControl(user, service);
                }
            };
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
            this.refreshViewer();
        }
    }

    protected Button createGrantExclusiveServiceButton(Composite parent, int style) {
        Button btn = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Grant Exclusive...", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doGrantExclusiveService(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createGrantExclusiveServiceButtonBindings(btn);
        btn.setToolTipText("Opens a wizard to select Services to be granted exclusively to the selected user.");
        return btn;
    }

    protected void createGrantExclusiveServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doGrantExclusiveService(List<MQTTROSArbitratorClientProfile> list) {
        for (final MQTTROSArbitratorClientProfile user : list) {
            MQTTArbitratorClientServiceWizard wizard = new MQTTArbitratorClientServiceWizard((MQTTROSArbitratorServer)this.getRootEObject(), user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES, null){

                @Override
                protected AbstractServiceSelectionWizardPage createServiceSelectionWizardPage(MQTTROSArbitratorServer server, MQTTROSArbitratorClientProfile user2) {
                    return new AbstractServiceSelectionWizardPage(server, user2){

                        @Override
                        protected EStructuralFeature getUserProfileServicesFeature() {
                            return ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES;
                        }

                        @Override
                        protected List<MQTTROSArbitratorServiceID> getAvailableServices(MQTTROSArbitratorClientProfile profile) {
                            ArrayList<MQTTROSArbitratorServiceID> availableServices = new ArrayList<MQTTROSArbitratorServiceID>();
                            for (MQTTROSArbitratorServiceID service : this.server.getServices()) {
                                if (this.server.findExclusiveUser(service) != null) continue;
                                availableServices.add(service);
                            }
                            return availableServices;
                        }
                    };
                }

                @Override
                protected void processService(MQTTROSArbitratorServer server, MQTTROSArbitratorServiceID service) throws Exception {
                    if (!server.grantExclusiveControl(user, service)) {
                        String message = "Failed to exclusive grant Service <" + service.getServiceName() + "> to User <" + user.getUserID() + "> !";
                        MessageDialog.openError((Shell)MQTTROSArbitratorClientProfileComposite.this.getShell(), (String)"Error", (String)message);
                    }
                }
            };
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
            this.refreshViewer();
        }
    }

    protected Button createRevokeExclusiveServiceButton(Composite parent, int style) {
        Button btn = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Revoke Exclusive...", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doRevoketExclusiveService(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        btn.setToolTipText("Opens a wizard to select exclusive Services to be revoked from the selected user.");
        this.createRevokeExclusiveServiceButtonBindings(btn);
        return btn;
    }

    protected void createRevokeExclusiveServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doRevoketExclusiveService(List<MQTTROSArbitratorClientProfile> list) {
        for (final MQTTROSArbitratorClientProfile user : list) {
            MQTTArbitratorClientServiceWizard wizard = new MQTTArbitratorClientServiceWizard((MQTTROSArbitratorServer)this.getRootEObject(), user, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES, null){

                @Override
                protected AbstractServiceSelectionWizardPage createServiceSelectionWizardPage(MQTTROSArbitratorServer server, MQTTROSArbitratorClientProfile user2) {
                    return new AbstractServiceSelectionWizardPage(server, user2){

                        @Override
                        protected EStructuralFeature getUserProfileServicesFeature() {
                            return ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES;
                        }

                        @Override
                        protected List<MQTTROSArbitratorServiceID> getAvailableServices(MQTTROSArbitratorClientProfile profile) {
                            ArrayList<MQTTROSArbitratorServiceID> availableServices = new ArrayList<MQTTROSArbitratorServiceID>((Collection<MQTTROSArbitratorServiceID>)this.user.getExclusivelyGrantedServices());
                            return availableServices;
                        }
                    };
                }

                @Override
                protected void processService(MQTTROSArbitratorServer server, MQTTROSArbitratorServiceID service) throws Exception {
                    server.revokeExclusiveControl(user, service);
                }
            };
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
            this.refreshViewer();
        }
    }

    protected Button createRevokeAllServiceButton(Composite parent, int style) {
        Button btnActivate = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Revoke All Service", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doRevokeAllServices(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createRevokeAllServiceButtonBindings(btnActivate);
        return btnActivate;
    }

    protected void createRevokeAllServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doRevokeAllServices(List<MQTTROSArbitratorClientProfile> list) {
        for (MQTTROSArbitratorClientProfile user : list) {
            try {
                MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)this.getRootEObject();
                ArrayList services = new ArrayList(user.getGrantedServices());
                for (MQTTROSArbitratorServiceID service : services) {
                    server.revokeControl(user, service);
                }
                services = new ArrayList(user.getExclusivelyGrantedServices());
                for (MQTTROSArbitratorServiceID service : services) {
                    server.revokeExclusiveControl(user, service);
                }
            }
            catch (Exception exception) {}
        }
        this.getViewer().refresh(true);
    }

    protected Button createAddClientButton(Composite parent, int style) {
        Button btnActivate = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Add Client...", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doAddClient();
            this.refreshViewer();
        }));
        this.creatAddClienteButtonBindings(btnActivate);
        return btnActivate;
    }

    protected void creatAddClienteButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> true);
    }

    protected void doAddClient() {
        MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)this.getRootEObject();
        MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
        settings.getUserDataMap().put("server", server);
        EObjectWizard wizard = new EObjectWizard((EObject)server, null, ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__USERS, ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        this.getViewer().refresh(true);
    }

    protected Button createDeleteClientButton(Composite parent, int style) {
        Button btnActivate = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Delete Client", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doDeleteClient(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.creatAddClienteButtonBindings(btnActivate);
        return btnActivate;
    }

    protected void createDeleteClientButtonButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doDeleteClient(List<MQTTROSArbitratorClientProfile> list) {
        for (MQTTROSArbitratorClientProfile client : list) {
            try {
                ((MQTTROSArbitratorServer)this.getResolvedEObject()).removeUser(client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getViewer().refresh(true);
    }

    protected Button createClearUserTokensButton(Composite parent, int style) {
        Button btnClearTokens = MQTTROSArbitratorClientProfileComposite.createButton((Composite)parent, (int)0, (String)"Clear Client Tokens", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doClearClientTokens(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createClearUserTokensButtonBindings(btnClearTokens);
        return btnClearTokens;
    }

    protected void doClearClientTokens(List<MQTTROSArbitratorClientProfile> list) {
        for (MQTTROSArbitratorClientProfile client : list) {
            try {
                ((MQTTROSArbitratorServer)this.getResolvedEObject()).clearUserTokenHistory(client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getViewer().refresh(true);
    }

    protected void createClearUserTokensButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }
}

