/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.ui.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSFactory;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSPackage;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorClientProfile;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServiceID;
import org.eclipse.apogy.addons.mqtt.ros.ui.impl.MQTTROSArbitratorClientProfileWizardPagesProviderImpl;
import org.eclipse.apogy.addons.mqtt.ros.ui.wizards.AbstractServiceSelectionWizardPage;
import org.eclipse.apogy.addons.mqtt.ros.ui.wizards.MQTTROSArbitratorClientProfileUserIdWizardPage;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;

public class MQTTROSArbitratorClientProfileWizardPagesProviderCustomImpl
extends MQTTROSArbitratorClientProfileWizardPagesProviderImpl {
    private MQTTROSArbitratorServer server;

    public EObject createEObject(EClass eClass, EClassSettings settings) {
        if (settings instanceof MapBasedEClassSettings) {
            MapBasedEClassSettings mapBasedEClassSettings = (MapBasedEClassSettings)settings;
            this.server = (MQTTROSArbitratorServer)mapBasedEClassSettings.getUserDataMap().get("server");
        }
        return ApogyAddonsMQTTROSFactory.eINSTANCE.createMQTTROSArbitratorClientProfile();
    }

    public EList<WizardPage> instantiateWizardPages(EObject eObject, EClassSettings settings) {
        EList pages = super.instantiateWizardPages(eObject, settings);
        MQTTROSArbitratorClientProfile user = (MQTTROSArbitratorClientProfile)eObject;
        MQTTROSArbitratorClientProfileUserIdWizardPage idWizardPage = new MQTTROSArbitratorClientProfileUserIdWizardPage(user);
        idWizardPage.setTitle("Set the ID of the new Client.");
        idWizardPage.setMessage("");
        pages.add((Object)idWizardPage);
        AbstractServiceSelectionWizardPage grantedServicesPage = this.createAbstractServiceSelectionWizardPage(this.server, user);
        grantedServicesPage.setTitle("Select the new Client Granted Services.");
        pages.add((Object)grantedServicesPage);
        AbstractServiceSelectionWizardPage exclusivelyGrantedServicesPage = this.createAbstractExclusiveServiceSelectionWizardPage(this.server, user);
        exclusivelyGrantedServicesPage.setTitle("Select the new Client Exclusively Granted Services.");
        pages.add((Object)exclusivelyGrantedServicesPage);
        return pages;
    }

    private AbstractServiceSelectionWizardPage createAbstractServiceSelectionWizardPage(MQTTROSArbitratorServer server, MQTTROSArbitratorClientProfile user) {
        return new AbstractServiceSelectionWizardPage(server, user){

            @Override
            protected EStructuralFeature getUserProfileServicesFeature() {
                return ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__GRANTED_SERVICES;
            }

            @Override
            protected List<MQTTROSArbitratorServiceID> getAvailableServices(MQTTROSArbitratorClientProfile profile) {
                ArrayList<MQTTROSArbitratorServiceID> availableServices = new ArrayList<MQTTROSArbitratorServiceID>();
                for (MQTTROSArbitratorServiceID service : this.server.getServices()) {
                    if (profile.getGrantedServices().contains((Object)service) || profile.getExclusivelyGrantedServices().contains((Object)service)) continue;
                    availableServices.add(service);
                }
                return availableServices;
            }

            @Override
            protected void selectionChanged(List<MQTTROSArbitratorServiceID> selectedServices) {
                ArrayList previousServcies = new ArrayList(this.user.getGrantedServices());
                for (MQTTROSArbitratorServiceID service : previousServcies) {
                    this.server.revokeControl(this.user, service);
                }
                for (MQTTROSArbitratorServiceID service : selectedServices) {
                    this.server.grantControl(this.user, service);
                }
            }

            public boolean isPageComplete() {
                return true;
            }
        };
    }

    private AbstractServiceSelectionWizardPage createAbstractExclusiveServiceSelectionWizardPage(MQTTROSArbitratorServer server, MQTTROSArbitratorClientProfile user) {
        return new AbstractServiceSelectionWizardPage(server, user){

            @Override
            protected EStructuralFeature getUserProfileServicesFeature() {
                return ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_CLIENT_PROFILE__EXCLUSIVELY_GRANTED_SERVICES;
            }

            @Override
            protected List<MQTTROSArbitratorServiceID> getAvailableServices(MQTTROSArbitratorClientProfile profile) {
                ArrayList<MQTTROSArbitratorServiceID> availableServices = new ArrayList<MQTTROSArbitratorServiceID>();
                for (MQTTROSArbitratorServiceID service : this.server.getServices()) {
                    if (this.server.findExclusiveUser(service) != null) continue;
                    availableServices.add(service);
                }
                return availableServices;
            }

            @Override
            protected void selectionChanged(List<MQTTROSArbitratorServiceID> selectedServices) {
                ArrayList previousServcies = new ArrayList(this.user.getExclusivelyGrantedServices());
                for (MQTTROSArbitratorServiceID service : previousServcies) {
                    this.server.revokeExclusiveControl(this.user, service);
                }
                for (MQTTROSArbitratorServiceID service : selectedServices) {
                    this.server.grantExclusiveControl(this.user, service);
                }
            }

            public boolean isPageComplete() {
                return true;
            }
        };
    }
}

