/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.core.environment.Star;
import org.eclipse.apogy.core.environment.impl.EnvironmentUtilitiesImpl;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtilitiesCustomImpl
extends EnvironmentUtilitiesImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EnvironmentUtilitiesImpl.class);
    public static final float MINUTES_PER_DAY = 1440.0f;
    public static final float SECONDS_PER_DAY = 86400.0f;
    public static final int JGREG = 588829;
    public static final double HALFSECOND = 0.5;

    @Override
    public double convertToJulianDate(Date date) {
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "GMT");
        Calendar calendar = Calendar.getInstance(timeZone, Locale.CANADA);
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        double a = Math.floor((14.0 - (double)month) / 12.0);
        double y = (double)year + 4800.0 - a;
        double m = (double)month + 12.0 * a - 3.0;
        double jdn = (double)day + Math.floor((153.0 * m + 2.0) / 5.0) + 365.0 * y + Math.floor(y / 4.0) - Math.floor(y / 100.0) + Math.floor(y / 400.0) - 32045.0;
        double fraction = ((double)hour - 12.0) / 24.0 + (double)min / 1440.0 + (double)sec / 86400.0;
        double jd = jdn + fraction;
        return jd;
    }

    @Override
    public float parseRightAscension(String rightAscensionString) throws Exception {
        float angle = 0.0f;
        String[] values = rightAscensionString.trim().split(":");
        float hour = Float.parseFloat(values[0]);
        float min = Float.parseFloat(values[1]);
        float sec = Float.parseFloat(values[2]);
        float dayFraction = hour / 24.0f + min / 1440.0f + sec / 86400.0f;
        angle = (float)((double)(dayFraction * 2.0f) * Math.PI);
        return angle;
    }

    @Override
    public float parseDegMinSec(String degMinSecAngleString) {
        float angle = 0.0f;
        String[] values = degMinSecAngleString.trim().split(":");
        float deg = Float.parseFloat(values[0]);
        float sign = 1.0f;
        if (values[0].contains("-")) {
            sign = -1.0f;
        }
        float min = Float.parseFloat(values[1]);
        float sec = Float.parseFloat(values[2]);
        angle = Math.abs(deg) + min / 60.0f + sec / 3600.0f;
        angle = sign * angle;
        angle = (float)Math.toRadians(angle);
        return angle;
    }

    @Override
    public SortedSet<Star> sortByMagnitude(List<Star> stars) {
        TreeSet<Star> sortedStars = new TreeSet<Star>(new StarMagnitudeComparator());
        sortedStars.addAll(stars);
        return sortedStars;
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.convertToJulianDate((Date)arguments.get(0));
            }
            case 1: {
                try {
                    return Float.valueOf(this.parseRightAscension((String)arguments.get(0)));
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            case 2: {
                return Float.valueOf(this.parseDegMinSec((String)arguments.get(0)));
            }
            case 3: {
                return this.sortByMagnitude((List)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    private class StarMagnitudeComparator
    implements Comparator<Star> {
        private StarMagnitudeComparator() {
        }

        @Override
        public int compare(Star o1, Star o2) {
            if (o1.getMagnitude() > o2.getMagnitude()) {
                return 1;
            }
            if (o1.getMagnitude() < o2.getMagnitude()) {
                return -1;
            }
            if (o1.getEquatorialCoordinates().getRightAscension() > o2.getEquatorialCoordinates().getRightAscension()) {
                return 1;
            }
            if (o1.getEquatorialCoordinates().getRightAscension() < o2.getEquatorialCoordinates().getRightAscension()) {
                return -1;
            }
            if (o1.getEquatorialCoordinates().getDeclination() > o2.getEquatorialCoordinates().getDeclination()) {
                return 1;
            }
            if (o1.getEquatorialCoordinates().getDeclination() < o2.getEquatorialCoordinates().getDeclination()) {
                return -1;
            }
            return 0;
        }
    }
}

