/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.impl.WorksitesRegistryImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorksitesRegistryCustomImpl
extends WorksitesRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(WorksitesRegistryImpl.class);

    @Override
    public EList<AbstractWorksite> getWorksites() {
        if (this.worksites == null) {
            this.worksites = super.getWorksites();
            ArrayList<AbstractWorksite> list = new ArrayList<AbstractWorksite>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getTYPE_CONTRIBUTOR_EXTENSION_POINT_ID());
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                String uri_str = contributor.getAttribute(this.getTYPE_CONTRIBUTOR_URI_ID());
                URI typeURI = URI.createURI((String)("platform:/plugin/" + contributor.getNamespaceIdentifier() + "/" + uri_str), (boolean)true);
                try {
                    TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
                    Resource resource = domain.getResourceSet().getResource(typeURI, true);
                    resource.load(Collections.EMPTY_MAP);
                    EObject content = (EObject)resource.getContents().get(0);
                    if (content instanceof AbstractWorksite) {
                        AbstractWorksite worksite = (AbstractWorksite)content;
                        list.add(worksite);
                    } else {
                        Logger.error(String.valueOf(typeURI.toString()) + " does not contain a valid Apogy Worksite model");
                    }
                }
                catch (Throwable t) {
                    Logger.error("Unable to load " + typeURI.toString(), t);
                }
                ++i;
            }
            this.worksites.addAll(list);
        }
        return this.worksites;
    }
}

