/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.converters.IConverter;

public class ChainedConverter
implements IConverter {
    protected List<IConverter> converters = new ArrayList<IConverter>();

    public ChainedConverter(List<IConverter> converters) {
        this.converters = converters;
    }

    public int getChainSize() {
        return this.converters.size();
    }

    @Override
    public Class<?> getOutputType() {
        if (this.converters.size() > 0) {
            IConverter lastConverter = this.converters.get(this.converters.size() - 1);
            return lastConverter.getOutputType();
        }
        return null;
    }

    @Override
    public Class<?> getInputType() {
        if (this.converters.size() > 0) {
            IConverter firstConverter = this.converters.get(0);
            return firstConverter.getInputType();
        }
        return null;
    }

    @Override
    public boolean canConvert(Object input) {
        return true;
    }

    @Override
    public Object convert(Object input) throws Exception {
        Object in = input;
        Object out = null;
        for (IConverter converter : this.converters) {
            if (converter.canConvert(in)) {
                in = out = converter.convert(in);
                continue;
            }
            return null;
        }
        return out;
    }

    public List<IConverter> getConverters() {
        return this.converters;
    }

    public void setConverters(List<IConverter> converters) {
        this.converters = converters;
    }

    public String toString() {
        String string = new String("[");
        Iterator<IConverter> it = this.converters.iterator();
        while (it.hasNext()) {
            IConverter converter = it.next();
            string = String.valueOf(string) + converter.getClass().getSimpleName();
            if (!it.hasNext()) continue;
            string = String.valueOf(string) + ", ";
        }
        string = String.valueOf(string) + "]";
        return string;
    }
}

