/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.converters.IConverter;

public class ConverterListConverter
implements IConverter {
    protected List<IConverter> converters = new ArrayList<IConverter>();

    public boolean addConverter(IConverter converter) {
        if (this.converters.isEmpty()) {
            this.converters.add(converter);
            return true;
        }
        if (converter.getInputType() == this.getInputType() && converter.getOutputType() == this.getOutputType()) {
            this.converters.add(converter);
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getOutputType() {
        if (this.converters.size() > 0) {
            IConverter lastConverter = this.converters.get(0);
            return lastConverter.getOutputType();
        }
        return null;
    }

    @Override
    public Class<?> getInputType() {
        if (this.converters.size() > 0) {
            IConverter lastConverter = this.converters.get(0);
            return lastConverter.getInputType();
        }
        return null;
    }

    @Override
    public boolean canConvert(Object input) {
        boolean canConvert = false;
        Iterator<IConverter> it = this.converters.iterator();
        while (!canConvert && it.hasNext()) {
            IConverter converter = it.next();
            try {
                canConvert = converter.canConvert(input);
            }
            catch (Exception exception) {}
        }
        return canConvert;
    }

    @Override
    public Object convert(Object input) throws Exception {
        Object output = null;
        Iterator<IConverter> it = this.converters.iterator();
        while (output == null && it.hasNext()) {
            IConverter converter = it.next();
            if (!converter.canConvert(input)) continue;
            try {
                output = converter.convert(input);
            }
            catch (Exception exception) {}
        }
        return output;
    }
}

