/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.INodeVisitor;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.impl.EarthSurfaceWorksiteNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class EarthSurfaceWorksiteNodeCustomImpl
extends EarthSurfaceWorksiteNodeImpl {
    private Adapter earthSurfaceWorksiteAdapter;

    @Override
    public TransformNode getSkyTransformNode() {
        TransformNode transformNode = super.getSkyTransformNode();
        if (transformNode == null) {
            if (this.getWorksite() instanceof EarthSurfaceWorksite) {
                EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)this.getWorksite();
                transformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, earthSurfaceWorksite.getXAxisAzimuth());
            } else {
                transformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            transformNode.setNodeId("SKY_TRANSFORM");
            transformNode.setDescription("Transform used to orient the sky to factor in the EarthSurfaceWorksite X Axis Azimuth.");
            this.getChildren().add((Object)transformNode);
            this.setSkyTransformNode(transformNode);
        }
        return transformNode;
    }

    public void setWorksite(Worksite newWorksite) {
        if (this.getWorksite() instanceof EarthSurfaceWorksite) {
            this.getWorksite().eAdapters().remove((Object)this.getEarthSurfaceWorksiteAdapter());
        }
        super.setWorksite(newWorksite);
        if (newWorksite instanceof EarthSurfaceWorksite) {
            EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)newWorksite;
            earthSurfaceWorksite.eAdapters().add((Object)this.getEarthSurfaceWorksiteAdapter());
            this.updateSkyTransform(earthSurfaceWorksite.getXAxisAzimuth());
        }
    }

    public void accept(INodeVisitor visitor) {
        if (visitor.getType().isInstance(this)) {
            visitor.visit((Node)this);
        }
        for (Node child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    private void updateSkyTransform(double xAxisAzimuth) {
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        matrix.rotZ(-xAxisAzimuth);
        this.getSkyTransformNode().setTransformation(matrix);
    }

    private Adapter getEarthSurfaceWorksiteAdapter() {
        if (this.earthSurfaceWorksiteAdapter == null) {
            this.earthSurfaceWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(EarthSurfaceWorksite.class) == 10) {
                        EarthSurfaceWorksiteNodeCustomImpl.this.updateSkyTransform(msg.getNewDoubleValue());
                    }
                }
            };
        }
        return this.earthSurfaceWorksiteAdapter;
    }
}

