/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.mqtt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.mqtt.impl.SystemElementMQTTMessageConverterImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.json.JSONObject;

public class SystemElementMQTTMessageConverterCustomImpl
extends SystemElementMQTTMessageConverterImpl {
    public static final String ECLASS_KEY = "eclass_name";
    public static final String NAME_KEY = "name";

    @Override
    public void apply(JSONObject jsonObject, SystemElement systemElement) throws Exception {
        List<EStructuralFeature> features = this.getSerializedEStructuralFeature();
        Iterator<EStructuralFeature> it = features.iterator();
        while (it.hasNext()) {
            try {
                String key;
                EStructuralFeature feature = it.next();
                if (!(feature instanceof EAttribute) || !jsonObject.has(key = feature.getName())) continue;
                String valueString = jsonObject.getString(key);
                EDataType eDataType = ((EAttribute)feature).getEAttributeType();
                Object value = EcoreUtil.createFromString((EDataType)eDataType, (String)valueString);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)systemElement, feature, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void convertToJSON(SystemElement systemElement, JSONObject jsonObject) throws Exception {
        jsonObject.put(ECLASS_KEY, (Object)systemElement.eClass().getInstanceClassName());
        List<EStructuralFeature> features = this.getSerializedEStructuralFeature();
        Iterator<EStructuralFeature> it = features.iterator();
        while (it.hasNext()) {
            try {
                EStructuralFeature feature = it.next();
                if (!(feature instanceof EAttribute)) continue;
                String key = feature.getName();
                EDataType eDataType = ((EAttribute)feature).getEAttributeType();
                Object value = systemElement.eGet(feature, true);
                String stringValue = EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
                jsonObject.put(key, (Object)stringValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<EStructuralFeature> getSerializedEStructuralFeature() {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        features.add((EStructuralFeature)ApogyCommonEMFPackage.Literals.NAMED__NAME);
        features.add((EStructuralFeature)ApogyCommonEMFPackage.Literals.DESCRIBED__DESCRIPTION);
        return features;
    }
}

