/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.impl;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.apogy.addons.sensors.pose.impl.CSVDataLoggerImpl;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataLoggerCustomImpl
extends CSVDataLoggerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CSVDataLoggerImpl.class);
    private BufferedWriter csvWriter = null;

    @Override
    public void setOutputFile(String newOutputFile) {
        String oldOutputFile = this.outputFile;
        this.outputFile = newOutputFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldOutputFile, (Object)this.outputFile));
        }
        if (this.csvWriter != null) {
            try {
                this.csvWriter.flush();
                this.csvWriter.close();
                this.csvWriter = null;
            }
            catch (Exception exception) {
                Logger.error("Failed to open file < for output.");
            }
        }
    }

    @Override
    public void logPose(Pose pose) throws IOException {
        double tx = pose.getX();
        double ty = pose.getY();
        double tz = pose.getZ();
        double rx = pose.getXRotation();
        double ry = pose.getYRotation();
        double rz = pose.getZRotation();
        long timeStamp = System.currentTimeMillis();
        String line = String.valueOf(Long.toString(timeStamp)) + "," + Double.toString(tx) + "," + Double.toString(ty) + "," + Double.toString(tz) + ",";
        line = String.valueOf(line) + Double.toString(rx) + "," + Double.toString(ry) + "," + Double.toString(rz) + "\n";
        this.getCsvWriter().write(line);
    }

    private BufferedWriter getCsvWriter() throws IOException {
        if (this.csvWriter == null) {
            this.csvWriter = new BufferedWriter(new FileWriter(this.getOutputFile()));
            String header = "Time stam,tx,ty,tz,rx,ry,rz \n";
            this.csvWriter.write(header);
            Logger.info("Sucessfully openned file < for output.");
        }
        return this.csvWriter;
    }

    protected void finalize() throws Throwable {
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
    }
}

