/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.paths.impl;

import geometry_msgs.Point;
import geometry_msgs.Pose;
import geometry_msgs.PoseStamped;
import geometry_msgs.Quaternion;
import nav_msgs.Path;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.ros.data3d.ApogyAddonsROSData3dFacade;
import org.eclipse.apogy.addons.ros.paths.impl.ApogyAddonsROSPathFacadeImpl;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.ros.message.MessageFactory;

public class ApogyAddonsROSPathFacadeCustomImpl
extends ApogyAddonsROSPathFacadeImpl {
    @Override
    public WayPointPath convertToWayPointPath(Path rosPath) {
        WayPointPath wayPointPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        for (PoseStamped pose : rosPath.getPoses()) {
            CartesianPositionCoordinates point = ApogyAddonsROSData3dFacade.INSTANCE.convertToCartesianPositionCoordinates(pose.getPose().getPosition());
            wayPointPath.getPoints().add((Object)point);
        }
        return wayPointPath;
    }

    @Override
    public Path convertToROSPath(WayPointPath wayPointPath, MessageFactory messageFactory) {
        Path path = (Path)messageFactory.newFromType("nav_msgs/Path");
        for (CartesianPositionCoordinates p : wayPointPath.getPoints()) {
            PoseStamped poseStamped = (PoseStamped)messageFactory.newFromType("geometry_msgs/PoseStamped");
            Pose pose = (Pose)messageFactory.newFromType("geometry_msgs/Pose");
            Point position = (Point)messageFactory.newFromType("geometry_msgs/Point");
            position.setX(p.getX());
            position.setY(p.getY());
            position.setZ(p.getZ());
            pose.setPosition(position);
            Quaternion quat = (Quaternion)messageFactory.newFromType("geometry_msgs/Quaternion");
            quat.setZ(1.0);
            pose.setOrientation(quat);
            poseStamped.setPose(pose);
            path.getPoses().add(poseStamped);
        }
        return path;
    }
}

