/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.VisibilityPassSpacecraftPositionHistoryComposite;
import org.eclipse.apogy.core.environment.earth.orbit.ui.composites.VisibilityPassSpacecraftPositionHistoryDetailsComposite;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PlannerSolutionComposite<RootEObject extends EObject, ResolvedEObject extends EObjectReferencesList<ObservationAnalysisPlannerNode>, ItemObject extends ObservationAnalysisPlannerNode>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    public static final DecimalFormat DURATION_FORMAT = new DecimalFormat("0.00");
    private static final int SOLUTION_ID_COL_MIN_WIDTH = 100;
    private static final int SPACECRAFT_COL_MIN_WIDTH = 100;
    private static final int LOCATION_COL_MIN_WIDTH = 100;
    private static final int FROM_DATE_COL_MIN_WIDTH = 200;
    private static final int TO_DATE_COL_MIN_WIDTH = 200;
    private static final int DURATION_COL_MIN_WIDTH = 120;
    private static final int COST_COL_MIN_WIDTH = 100;
    private VisibilityPassSpacecraftPositionHistoryComposite<VisibilityPass, VisibilityPass> visibilityPassSpacecraftPositionHistoryComposite;
    private VisibilityPassSpacecraftPositionHistoryDetailsComposite<VisibilityPass> visibilityPassSpacecraftPositionHistoryDetailsComposite;
    private Composite emfFormscomposite;

    public PlannerSolutionComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyCommonEMFPackage.Literals.EOBJECT_REFERENCES_LIST__EOBJECTS, settings);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn idColumn = new TreeViewerColumn(viewer, 0);
        idColumn.getColumn().setText("ID");
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ObservationAnalysisPlannerNode)element).getId();
            }
        });
        idColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn spacecraftColumn = new TreeViewerColumn(viewer, 0);
        spacecraftColumn.getColumn().setText("Spacecraft");
        spacecraftColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ObservationAnalysisPlannerNode)element).getPass().getSpacecraft().getName();
            }
        });
        spacecraftColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn locationColumn = new TreeViewerColumn(viewer, 0);
        locationColumn.getColumn().setText("Location");
        locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ObservationAnalysisPlannerNode)element).getPass().getOutlook().getName();
            }
        });
        locationColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn fromDateColumn = new TreeViewerColumn(viewer, 0);
        fromDateColumn.getColumn().setText("From Date");
        fromDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.format(((ObservationAnalysisPlannerNode)element).getPass().getFromDate());
            }
        });
        fromDateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn toDateColumn = new TreeViewerColumn(viewer, 0);
        toDateColumn.getColumn().setText("To Date");
        toDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.format(((ObservationAnalysisPlannerNode)element).getPass().getToDate());
            }
        });
        toDateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn durationColumn = new TreeViewerColumn(viewer, 0);
        durationColumn.getColumn().setText("Duration (min)");
        durationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                VisibilityPass pass = ((ObservationAnalysisPlannerNode)element).getPass();
                return pass == null ? "N/A." : DURATION_FORMAT.format(1.6666666666666667E-5 * (double)ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)pass));
            }
        });
        durationColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn costColumn = new TreeViewerColumn(viewer, 0);
        costColumn.getColumn().setText("Cost");
        costColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                double cost = ((ObservationAnalysisPlannerNode)element).getCost();
                if (cost == Double.POSITIVE_INFINITY) {
                    return "\u221e";
                }
                return Double.toString(cost);
            }
        });
        costColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(1, false));
        CTabFolder cTabFolder = new CTabFolder(top, 0);
        GridData tabFolderGridData = new GridData(4, 4, true, true);
        tabFolderGridData.minimumWidth = 400;
        tabFolderGridData.minimumHeight = 400;
        cTabFolder.setLayoutData((Object)tabFolderGridData);
        cTabFolder.setSelection(0);
        CTabItem overviewCTab = new CTabItem(cTabFolder, 64);
        overviewCTab.setText("Overview");
        this.visibilityPassSpacecraftPositionHistoryDetailsComposite = new VisibilityPassSpacecraftPositionHistoryDetailsComposite((Composite)cTabFolder, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS__POSITION_HISTORY}), null);
        overviewCTab.setControl(this.visibilityPassSpacecraftPositionHistoryDetailsComposite);
        CTabItem historyCTab = new CTabItem(cTabFolder, 64);
        historyCTab.setText("History");
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setButtonsSectionDisplayed(false);
        settings.setDetailSectionDisplayed(false);
        this.visibilityPassSpacecraftPositionHistoryComposite = new VisibilityPassSpacecraftPositionHistoryComposite((Composite)cTabFolder, 0, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS__POSITION_HISTORY}), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.VISIBILITY_PASS_SPACECRAFT_POSITION_HISTORY__POSITIONS, settings);
        historyCTab.setControl(this.visibilityPassSpacecraftPositionHistoryComposite);
        CTabItem detailCTab = new CTabItem(cTabFolder, 64);
        detailCTab.setText("Details");
        this.emfFormscomposite = new Composite((Composite)cTabFolder, style);
        this.emfFormscomposite.setLayout((Layout)new FillLayout());
        detailCTab.setControl((Control)this.emfFormscomposite);
        return top;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        VisibilityPass pass = this.getSelectedItemObjects() == null || this.getSelectedItemObjects().isEmpty() ? null : ((ObservationAnalysisPlannerNode)this.getSelectedItemObjects().get(0)).getPass();
        this.visibilityPassSpacecraftPositionHistoryDetailsComposite.setRootEObject(pass);
        this.visibilityPassSpacecraftPositionHistoryComposite.setRootEObject((EObject)pass);
        ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.emfFormscomposite, this.getSelectedItemObjects().isEmpty() ? null : (EObject)this.getSelectedItemObjects().get(0));
    }
}

