/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerFacade;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerPackage;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlanner;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ui.composites.PlannerSolutionsContentProvider;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ui.wizards.ExportObservationPlanWizard;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;

public class PlannerSolutionsComposite
extends EMFFormsEListComposite<ObservationAnalysisPlanner, ObservationAnalysisPlannerNode, ObservationAnalysisPlannerNode> {
    public static final DecimalFormat DURATION_FORMAT = new DecimalFormat("0.00");
    public static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("0.00");
    private static final int SOLUTION_ID_COL_MIN_WIDTH = 100;
    private static final int FROM_DATE_COL_MIN_WIDTH = 200;
    private static final int TO_DATE_COL_MIN_WIDTH = 200;
    private static final int DURATION_COL_MIN_WIDTH = 120;
    private static final int RATIO_COL_MIN_WIDTH = 120;
    private static final int COVERAGE_COL_MIN_WIDTH = 100;
    private static final int COST_COL_MIN_WIDTH = 100;

    public PlannerSolutionsComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER__RESULT, ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_RESULT__PLAN_ROOT_NODE}), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_NODE__CHILDREN, settings);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new PlannerSolutionsContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return PlannerSolutionsComposite.this.getEStructuralFeature();
            }

            @Override
            public boolean hasChildren(Object object) {
                return false;
            }
        };
    }

    protected void createButtons(Composite parent, int style) {
        this.createExportButton(parent, style);
    }

    protected void doExport() {
        EObjectReferencesList plan = ApogyCoreEnvironmentEarthOrbitPlannerFacade.INSTANCE.getPlannerSolution((ObservationAnalysisPlannerNode)this.getSelectedItemObjects().get(0));
        ExportObservationPlanWizard wizard = new ExportObservationPlanWizard(ApogyCoreEnvironmentEarthOrbitPlannerFacade.INSTANCE.getObservationAnalysisPlannerTool(), (EObjectReferencesList<ObservationAnalysisPlannerNode>)plan, (ObservationAnalysisPlanner)this.getRootEObject());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn idColumn = new TreeViewerColumn(viewer, 0);
        idColumn.getColumn().setWidth(75);
        idColumn.getColumn().setText("ID");
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ObservationAnalysisPlannerNode)element).getId();
            }
        });
        idColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn fromDateColumn = new TreeViewerColumn(viewer, 0);
        fromDateColumn.getColumn().setWidth(225);
        fromDateColumn.getColumn().setText("From Date");
        fromDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.format(((ObservationAnalysisPlannerNode)element).getFirstLevelNode().getPass().getFromDate());
            }
        });
        fromDateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn toDateColumn = new TreeViewerColumn(viewer, 0);
        toDateColumn.getColumn().setWidth(225);
        toDateColumn.getColumn().setText("To Date");
        toDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.format(((ObservationAnalysisPlannerNode)element).getPass().getToDate());
            }
        });
        toDateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn solutionDurationColumn = new TreeViewerColumn(viewer, 0);
        solutionDurationColumn.getColumn().setWidth(225);
        solutionDurationColumn.getColumn().setText("Solution Duration (min)");
        solutionDurationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return DURATION_FORMAT.format(1.6666666666666667E-5 * ((ObservationAnalysisPlannerNode)element).getSolutionDuration());
            }
        });
        solutionDurationColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn passesDurationColumn = new TreeViewerColumn(viewer, 0);
        passesDurationColumn.getColumn().setWidth(225);
        passesDurationColumn.getColumn().setText("Passes Duration (min)");
        passesDurationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return DURATION_FORMAT.format(1.6666666666666667E-5 * ((ObservationAnalysisPlannerNode)element).getTotalPassesDuration());
            }
        });
        passesDurationColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn usageRatioColumn = new TreeViewerColumn(viewer, 0);
        usageRatioColumn.getColumn().setWidth(225);
        usageRatioColumn.getColumn().setText("Usage Ratio (%)");
        usageRatioColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return DURATION_FORMAT.format(((ObservationAnalysisPlannerNode)element).getSolutionDuration() < 0.001 ? 0.0 : 100.0 * ((ObservationAnalysisPlannerNode)element).getTotalPassesDuration() / ((ObservationAnalysisPlannerNode)element).getSolutionDuration());
            }
        });
        passesDurationColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn coverageColumn = new TreeViewerColumn(viewer, 0);
        coverageColumn.getColumn().setWidth(225);
        coverageColumn.getColumn().setText("Coverage (%)");
        coverageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return PERCENT_FORMAT.format((double)((ObservationAnalysisPlannerNode)element).getLevel() / (double)((ObservationAnalysisPlanner)PlannerSolutionsComposite.this.getRootEObject()).getOrbitAnalysisData().getObservationTargets().size() * 100.0);
            }
        });
        coverageColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn costColumn = new TreeViewerColumn(viewer, 0);
        costColumn.getColumn().setWidth(225);
        costColumn.getColumn().setText("Cost");
        costColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                double cost = ApogyCoreEnvironmentEarthOrbitPlannerFacade.INSTANCE.getSolutionTotalCost(ApogyCoreEnvironmentEarthOrbitPlannerFacade.INSTANCE.getPlannerSolution((ObservationAnalysisPlannerNode)element));
                if (cost == Double.POSITIVE_INFINITY) {
                    return "\u221e";
                }
                return Double.toString(cost);
            }
        });
        costColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }
}

