/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.ui.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.environment.earth.orbit.planner.AbstractObservationPlanExporter;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerPackage;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlanner;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerTool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationPlanExporterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.planner.ui.wizards.ObservationPlanExporterWizardPage";
    private static final Logger Logger = LoggerFactory.getLogger(ObservationPlanExporterWizardPage.class);
    private ObservationAnalysisPlannerTool observationAnalysisPlannerTool;
    private EObjectReferencesList<ObservationAnalysisPlannerNode> plan;
    private ObservationAnalysisPlanner planner;
    private EMFFormsEListComposite<ObservationAnalysisPlannerTool, AbstractObservationPlanExporter, AbstractObservationPlanExporter> availableExportersListComposite;
    private AbstractObservationPlanExporter selectedExporter = null;

    public ObservationPlanExporterWizardPage(ObservationAnalysisPlannerTool observationAnalysisPlannerTool, EObjectReferencesList<ObservationAnalysisPlannerNode> plan, ObservationAnalysisPlanner planner) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Select an Observation Plann Exporter and export an Observation Plan.");
        this.observationAnalysisPlannerTool = observationAnalysisPlannerTool;
        this.plan = plan;
        this.planner = planner;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.availableExportersListComposite = new EMFFormsEListComposite<ObservationAnalysisPlannerTool, AbstractObservationPlanExporter, AbstractObservationPlanExporter>(parent, 0, null, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_TOOL__OBSERVATION_PLAN_EXPORTERS){
            public static final int NAME_COL_MIN_WIDTH = 100;
            public static final int DESCRIPTION_COL_MIN_WIDTH = 100;

            protected void createButtons(Composite parent, int style) {
                this.createNewButton(parent, style);
                this.createDeleteButton(parent, style);
                this.createExportButton(parent, style);
            }

            protected void createColumns(TreeViewer viewer) {
                final TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
                nameColumn.getColumn().setText("Name");
                nameColumn.getColumn().setAlignment(0x1000000);
                nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof AbstractObservationPlanExporter) {
                            AbstractObservationPlanExporter importer = (AbstractObservationPlanExporter)element;
                            String text = importer.getName();
                            return text == null || text.length() == 0 ? "" : text;
                        }
                        return "";
                    }
                });
                nameColumn.getColumn().setWidth(100);
                nameColumn.getColumn().addControlListener(new ControlListener(){

                    public void controlResized(ControlEvent arg0) {
                        if (nameColumn.getColumn().getWidth() < 100) {
                            nameColumn.getColumn().setWidth(100);
                        }
                    }

                    public void controlMoved(ControlEvent arg0) {
                    }
                });
                final TreeViewerColumn descriptionColumn = new TreeViewerColumn(viewer, 0);
                descriptionColumn.getColumn().setText("Description");
                descriptionColumn.getColumn().setAlignment(0x1000000);
                descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof AbstractObservationPlanExporter) {
                            AbstractObservationPlanExporter importer = (AbstractObservationPlanExporter)element;
                            String text = importer.getDescription();
                            return text == null || text.length() == 0 ? "" : text;
                        }
                        return "";
                    }
                });
                descriptionColumn.getColumn().setWidth(100);
                descriptionColumn.getColumn().addControlListener(new ControlListener(){

                    public void controlResized(ControlEvent arg0) {
                        if (descriptionColumn.getColumn().getWidth() < 100) {
                            descriptionColumn.getColumn().setWidth(100);
                        }
                    }

                    public void controlMoved(ControlEvent arg0) {
                    }
                });
            }

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    ObservationPlanExporterWizardPage.this.setSelectedExporter((AbstractObservationPlanExporter)selection.getFirstElement());
                } else {
                    ObservationPlanExporterWizardPage.this.setSelectedExporter(null);
                }
            }

            protected void doNew() {
                MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                settings.getUserDataMap().put("name", ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)ObservationPlanExporterWizardPage.this.observationAnalysisPlannerTool, null, (ETypedElement)ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_TOOL__OBSERVATION_PLAN_EXPORTERS));
                EObjectWizard wizard = new EObjectWizard((EObject)ObservationPlanExporterWizardPage.this.observationAnalysisPlannerTool, null, ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_TOOL__OBSERVATION_PLAN_EXPORTERS);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.open();
            }

            protected void doExport() {
                try {
                    ObservationPlanExporterWizardPage.this.selectedExporter.exportObservationPlan(ObservationPlanExporterWizardPage.this.plan, ObservationPlanExporterWizardPage.this.planner, (IProgressMonitor)new NullProgressMonitor());
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Export Completed", (String)"Export Completed");
                    ObservationPlanExporterWizardPage.this.setPageComplete(true);
                }
                catch (Exception e) {
                    String message = "An exception occured during export : " + e.getMessage();
                    Logger.error(message, (Throwable)e);
                    MessageDialog.openError((Shell)this.getShell(), (String)"Export failed !", (String)message);
                    ObservationPlanExporterWizardPage.this.setPageComplete(false);
                }
            }
        };
        this.availableExportersListComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.availableExportersListComposite.setRootEObject((EObject)this.observationAnalysisPlannerTool);
        this.setControl((Control)this.availableExportersListComposite);
    }

    public void setSelectedExporter(AbstractObservationPlanExporter selectedExporter) {
        this.selectedExporter = selectedExporter;
    }
}

