/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm.ros.impl;

import org.eclipse.apogy.addons.ros.ApogyAddonsROSFactory;
import org.eclipse.apogy.addons.ros.ROSInterface;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.examples.robotic_arm.MoveSpeedLevel;
import org.eclipse.apogy.examples.robotic_arm.ros.RoboticArmROSConstants;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdInitRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdMoveToRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdMoveToResponse;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdSpeedLevelRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdSpeedLevelResponse;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdStowRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdStowResponse;
import org.eclipse.apogy.examples.robotic_arm.ros.impl.RoboticArmROSImpl;
import org.eclipse.apogy.examples.robotic_arm.ros.listeners.RoboticArmTelemetryListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.ros.internal.message.Message;
import org.ros.message.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoboticArmROSCustomImpl
extends RoboticArmROSImpl {
    private static final Logger Logger = LoggerFactory.getLogger(RoboticArmROSImpl.class);

    @Override
    public void rosInit() {
        this.topicLauncher.createListener("/roboticArm/Telemetry", "org.eclipse.apogy.examples.robotic_arm.ros/RoboticArmTelemetry", (MessageListener)new RoboticArmTelemetryListener(this));
        this.serviceManager.createService("/roboticArm/cmdMoveSpeed", "org.eclipse.apogy.examples.robotic_arm.ros/cmdSpeedLevel", false);
        this.serviceManager.createService("/roboticArm/cmdMoveTo", "org.eclipse.apogy.examples.robotic_arm.ros/cmdMoveTo", false);
        this.serviceManager.createService("/roboticArm/cmdStow", "org.eclipse.apogy.examples.robotic_arm.ros/cmdStow", false);
        if (!this.topicLauncher.isRunning()) {
            this.topicLauncher.launch();
        }
        if (!this.serviceManager.isRunning()) {
            this.serviceManager.launch();
        }
        if (!this.publisherManager.isRunning()) {
            this.publisherManager.launch();
        }
    }

    public boolean init() {
        if (!this.isInitialized()) {
            Logger.info("Start client node <" + RoboticArmROSConstants.ROBOTIC_ARM_CLIENT_NODE_NAME + ">.");
            ROSNode node = ApogyAddonsROSFactory.eINSTANCE.createROSNode();
            node.setNodeName(RoboticArmROSConstants.ROBOTIC_ARM_CLIENT_NODE_NAME);
            node.setEnableAutoRestartOnConnectionLost(false);
            try {
                node.initialize();
            }
            catch (Exception e) {
                Logger.error("Unable to start the node.", (Throwable)e);
                return false;
            }
            this.setNode(node);
            node.register((ROSInterface)this, false);
            node.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    boolean connected;
                    if (msg.getFeatureID(ROSNode.class) == 6 && (connected = msg.getNewBooleanValue())) {
                        Logger.info("Connected to Robotic Arm ROS server.");
                    }
                }
            });
            node.start();
            try {
                cmdInitRequest request = (cmdInitRequest)this.getServiceManager().createRequestMessage("/roboticArm/cmdInit");
                this.getServiceManager().callService("/roboticArm/cmdInit", (Message)request, true);
            }
            catch (Exception e) {
                Logger.error("Failed to call init() on the server.", (Throwable)e);
            }
            this.setInitialized(true);
        } else {
            try {
                cmdInitRequest request = (cmdInitRequest)this.getServiceManager().createRequestMessage("/roboticArm/cmdInit");
                this.getServiceManager().callService("/roboticArm/cmdInit", (Message)request, false);
            }
            catch (Exception e) {
                Logger.error("Failed to call init() on the server.", (Throwable)e);
            }
        }
        return true;
    }

    public void cmdMoveSpeedLevel(MoveSpeedLevel speedLevel) {
        cmdSpeedLevelRequest request = (cmdSpeedLevelRequest)this.getServiceManager().createRequestMessage("/roboticArm/cmdMoveSpeed");
        try {
            cmdSpeedLevelResponse response = (cmdSpeedLevelResponse)this.getServiceManager().callService("/roboticArm/cmdMoveSpeed", (Message)request, false, 2000);
            if (!response.getResult()) {
                throw new RuntimeException("Service RoboticArmROSConstants.SERVICE_NAME_MOVE_TO returned false !");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void moveTo(double turrentAngle, double shoulderAngle, double elbowAngle, double wristAngle) {
        int MAX_MOVE_TIME = 60000;
        cmdMoveToRequest request = (cmdMoveToRequest)this.getServiceManager().createRequestMessage("/roboticArm/cmdMoveTo");
        request.setTurretAngle((float)Math.toRadians(turrentAngle));
        request.setShoulderAngle((float)Math.toRadians(shoulderAngle));
        request.setElbowAngle((float)Math.toRadians(elbowAngle));
        request.setWristAngle((float)Math.toRadians(wristAngle));
        cmdMoveToResponse response = null;
        try {
            response = (cmdMoveToResponse)this.getServiceManager().callService("/roboticArm/cmdMoveTo", (Message)request, false, MAX_MOVE_TIME);
            if (response != null && response.getResult()) {
                throw new RuntimeException("Service RoboticArmROSConstants.SERVICE_NAME_MOVE_TO returned false !");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stow() {
        int MAX_STOW_TIME = 30000;
        cmdStowRequest request = (cmdStowRequest)this.getServiceManager().createRequestMessage("/roboticArm/cmdStow");
        try {
            cmdStowResponse response = (cmdStowResponse)this.getServiceManager().callService("/roboticArm/cmdStow", (Message)request, false, MAX_STOW_TIME);
            if (!response.getResult()) {
                throw new RuntimeException("Service RoboticArmROSConstants.SERVICE_NAME_MOVE_TO returned false !");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

