//*******************************************************************************
// Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// 	 	 Pierre Allard - initial API and implementation
// 	 	 
// SPDX-License-Identifier: EPL-1.0
//*******************************************************************************
#import "Common/ShaderLib/Optics.glsllib"

uniform float m_WarningSlope;
uniform float m_AlarmSlope;

varying vec3 normal;
varying vec3 position;

const vec3 vertical = vec3(0,0,1.0);

void main() 
{	
	// Compute the angle between the normal and the vertical.
	float angle = abs(acos(dot(normal, vertical)));	
	
	if(angle < m_WarningSlope)
	{
		gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);    
	}
	  	
	if(angle >= m_WarningSlope)
	{
		gl_FragColor = vec4(1.0, 1.0, 0.0, 1.0);    
	}  	
	
	if(angle >= m_AlarmSlope)
	{
		gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);    
	}  			
}

