/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.SceneProcessor;
import com.jme3.post.TextureProjector;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.Timer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.List;

public class AnimatedTextureProjectorRenderer
implements SceneProcessor {
    private RenderManager renderManager;
    private ViewPort viewPort;
    private final Material textureMat;
    private final ArrayList<TextureProjector> textureProjectors;
    private final Timer timer;
    private int numTilesU;
    private int numTilesV;
    private int speed;

    public AnimatedTextureProjectorRenderer(AssetManager assetManager, Timer timer, int numTilesU, int numTilesV, int speed) {
        this(assetManager, timer, numTilesU, numTilesV, speed, null);
    }

    public AnimatedTextureProjectorRenderer(AssetManager assetManager, Timer timer, int numTilesU, int numTilesV, int speed, ColorRGBA color) {
        this.numTilesU = numTilesU;
        this.numTilesV = numTilesV;
        this.speed = speed;
        this.timer = timer;
        this.textureMat = new Material(assetManager, "Common/MatDefs/Misc/ProjectiveAnimatedTextureMapping.j3md");
        this.textureMat.setInt("NumTilesU", numTilesU);
        this.textureMat.setInt("NumTilesV", numTilesV);
        this.textureMat.setInt("SelectedTileU", 0);
        this.textureMat.setInt("SelectedTileV", 0);
        this.textureProjectors = new ArrayList();
        this.renderManager = null;
        this.viewPort = null;
        this.setPolyOffset(-0.1f, -0.1f);
    }

    public List<TextureProjector> getTextureProjectors() {
        return this.textureProjectors;
    }

    public final void setPolyOffset(float factor, float units) {
        this.textureMat.getAdditionalRenderState().setPolyOffset(factor, units);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
    }

    public boolean isInitialized() {
        return this.viewPort != null;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        this.renderManager.setForcedMaterial(this.textureMat);
        this.renderManager.getRenderer().setFrameBuffer(out);
        for (TextureProjector textureProjector : this.textureProjectors) {
            float fallOffDistance = textureProjector.getFallOffDistance();
            this.textureMat.setTexture("ProjectiveMap", (Texture)textureProjector.getProjectiveTexture());
            this.textureMat.setMatrix4("ProjectorViewProjectionMatrix", textureProjector.getProjectorViewProjectionMatrix());
            float now = this.timer.getTimeInSeconds() * (float)this.speed;
            int selectedTileU = (int)(now % (float)this.numTilesU);
            int selectedTileV = (int)(now % (float)this.numTilesV);
            this.textureMat.setInt("SelectedTileU", selectedTileU);
            this.textureMat.setInt("SelectedTileV", selectedTileV);
            if (textureProjector.isParallelProjection()) {
                this.textureMat.clearParam("ProjectorLocation");
                this.textureMat.setVector3("ProjectorDirection", textureProjector.getProjectorDirection());
            } else {
                this.textureMat.clearParam("ProjectorDirection");
                this.textureMat.setVector3("ProjectorLocation", textureProjector.getProjectorLocation());
            }
            if (fallOffDistance != Float.MAX_VALUE) {
                this.textureMat.setFloat("FallOffDistance", textureProjector.getFallOffDistance());
                this.textureMat.setFloat("FallOffPower", textureProjector.getFallOffPower());
            } else {
                this.textureMat.clearParam("FallOffDistance");
                this.textureMat.clearParam("FallOffPower");
            }
            GeometryList targetGeometryList = textureProjector.getTargetGeometryList();
            if (targetGeometryList != null) {
                this.renderManager.renderGeometryList(targetGeometryList);
                continue;
            }
            this.renderManager.renderViewPortRaw(this.viewPort);
        }
        this.renderManager.setForcedMaterial(null);
    }

    public void cleanup() {
    }

    public void reshape(ViewPort vp, int w, int h) {
    }
}

