/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.fitting.PolynomialFitter;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.GaussNewtonOptimizer;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;

public class SmoothingPolynomialBicubicSplineInterpolator
extends BicubicSplineInterpolator {
    private final PolynomialFitter xFitter;
    private final int xDegree;
    private final PolynomialFitter yFitter;
    private final int yDegree;

    public SmoothingPolynomialBicubicSplineInterpolator() {
        this(3);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int degree) throws NotPositiveException {
        this(degree, degree);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int xDegree, int yDegree) throws NotPositiveException {
        if (xDegree < 0) {
            throw new NotPositiveException(xDegree);
        }
        if (yDegree < 0) {
            throw new NotPositiveException(yDegree);
        }
        this.xDegree = xDegree;
        this.yDegree = yDegree;
        double safeFactor = 100.0;
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(100.0 * Precision.EPSILON, 100.0 * Precision.SAFE_MIN);
        this.xFitter = new PolynomialFitter(new GaussNewtonOptimizer(false, checker));
        this.yFitter = new PolynomialFitter(new GaussNewtonOptimizer(false, checker));
    }

    @Override
    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws NoDataException, NullArgumentException, DimensionMismatchException, NonMonotonicSequenceException {
        int i;
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        int xLen = xval.length;
        int yLen = yval.length;
        int i2 = 0;
        while (i2 < xLen) {
            if (fval[i2].length != yLen) {
                throw new DimensionMismatchException(fval[i2].length, yLen);
            }
            ++i2;
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        PolynomialFunction[] yPolyX = new PolynomialFunction[yLen];
        int j = 0;
        while (j < yLen) {
            this.xFitter.clearObservations();
            int i3 = 0;
            while (i3 < xLen) {
                this.xFitter.addObservedPoint(1.0, xval[i3], fval[i3][j]);
                ++i3;
            }
            yPolyX[j] = new PolynomialFunction(this.xFitter.fit(new double[this.xDegree + 1]));
            ++j;
        }
        double[][] fval_1 = new double[xLen][yLen];
        int j2 = 0;
        while (j2 < yLen) {
            PolynomialFunction f = yPolyX[j2];
            i = 0;
            while (i < xLen) {
                fval_1[i][j2] = f.value(xval[i]);
                ++i;
            }
            ++j2;
        }
        PolynomialFunction[] xPolyY = new PolynomialFunction[xLen];
        int i4 = 0;
        while (i4 < xLen) {
            this.yFitter.clearObservations();
            int j3 = 0;
            while (j3 < yLen) {
                this.yFitter.addObservedPoint(1.0, yval[j3], fval_1[i4][j3]);
                ++j3;
            }
            xPolyY[i4] = new PolynomialFunction(this.yFitter.fit(new double[this.yDegree + 1]));
            ++i4;
        }
        double[][] fval_2 = new double[xLen][yLen];
        i = 0;
        while (i < xLen) {
            PolynomialFunction f = xPolyY[i];
            int j4 = 0;
            while (j4 < yLen) {
                fval_2[i][j4] = f.value(yval[j4]);
                ++j4;
            }
            ++i;
        }
        return super.interpolate(xval, yval, fval_2);
    }
}

