/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.ui.jme3.scene_objects;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.ui.PathPresentationMode;
import org.eclipse.apogy.addons.geometry.paths.ui.WayPointPathSceneObject;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayPointPathJME3Object
extends DefaultJME3SceneObject<WayPointPath>
implements WayPointPathSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(WayPointPathJME3Object.class);
    public static ColorRGBA DEFAULT_START_POINT_COLOR = ColorRGBA.Red;
    public static ColorRGBA DEFAULT_END_POINT_COLOR = ColorRGBA.Blue;
    public static ColorRGBA DEFAULT_POINT_COLOR = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    private ColorRGBA lineColor = DEFAULT_POINT_COLOR;
    private final int pointSize = 1;
    private float endPointSize = 0.05f;
    private PathPresentationMode pathPresentationMode = PathPresentationMode.POINTS_LINES;
    private Point3d centroid = null;
    private Geometry pathLinesGeometry = null;
    private Geometry pathPointsGeometry = null;
    private com.jme3.scene.Node startPointNode;
    private com.jme3.scene.Node endPointNode;
    private Adapter modelListener;

    public WayPointPathJME3Object(WayPointPath node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        if (node == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        Job job = new Job("WayPointPathJME3Object : Updating geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                ((WayPointPath)WayPointPathJME3Object.this.getTopologyNode()).eAdapters().add((Object)WayPointPathJME3Object.this.getPointsListener());
                for (CartesianPositionCoordinates point : ((WayPointPath)WayPointPathJME3Object.this.getTopologyNode()).getPoints()) {
                    point.eAdapters().add((Object)WayPointPathJME3Object.this.getPointsListener());
                }
                WayPointPathJME3Object.this.requestUpdate();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        this.updateGeometry((WayPointPath)this.getTopologyNode());
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((WayPointPath)this.getTopologyNode()).eAdapters().remove((Object)this.getPointsListener());
            for (CartesianPositionCoordinates point : ((WayPointPath)this.getTopologyNode()).getPoints()) {
                point.eAdapters().remove((Object)this.getPointsListener());
            }
        }
        super.dispose();
    }

    public int getPointSize() {
        return 1;
    }

    public void setPathPresentationMode(final PathPresentationMode mode) {
        this.pathPresentationMode = mode;
        if (((WayPointPath)this.getTopologyNode()).getPoints().size() > 0) {
            Logger.info("Setting PathPresentationMode to <" + mode + ">.");
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    switch (mode.getValue()) {
                        case 1: {
                            if (WayPointPathJME3Object.this.pathPointsGeometry != null) {
                                WayPointPathJME3Object.this.getAttachmentNode().detachChild((Spatial)WayPointPathJME3Object.this.pathPointsGeometry);
                            }
                            if (WayPointPathJME3Object.this.pathLinesGeometry == null || WayPointPathJME3Object.this.getAttachmentNode().getChildren().contains(WayPointPathJME3Object.this.pathLinesGeometry)) break;
                            WayPointPathJME3Object.this.getAttachmentNode().attachChild((Spatial)WayPointPathJME3Object.this.pathLinesGeometry);
                            break;
                        }
                        case 0: {
                            if (WayPointPathJME3Object.this.pathLinesGeometry != null) {
                                WayPointPathJME3Object.this.getAttachmentNode().detachChild((Spatial)WayPointPathJME3Object.this.pathLinesGeometry);
                            }
                            if (WayPointPathJME3Object.this.pathPointsGeometry == null || WayPointPathJME3Object.this.getAttachmentNode().getChildren().contains(WayPointPathJME3Object.this.pathPointsGeometry)) break;
                            WayPointPathJME3Object.this.getAttachmentNode().attachChild((Spatial)WayPointPathJME3Object.this.pathPointsGeometry);
                            break;
                        }
                        case 2: {
                            if (WayPointPathJME3Object.this.pathLinesGeometry != null && !WayPointPathJME3Object.this.getAttachmentNode().getChildren().contains(WayPointPathJME3Object.this.pathLinesGeometry)) {
                                WayPointPathJME3Object.this.getAttachmentNode().attachChild((Spatial)WayPointPathJME3Object.this.pathLinesGeometry);
                            }
                            if (WayPointPathJME3Object.this.pathPointsGeometry == null || WayPointPathJME3Object.this.getAttachmentNode().getChildren().contains(WayPointPathJME3Object.this.pathPointsGeometry)) break;
                            WayPointPathJME3Object.this.getAttachmentNode().attachChild((Spatial)WayPointPathJME3Object.this.pathPointsGeometry);
                            break;
                        }
                    }
                    return null;
                }
            });
        } else {
            Logger.warn("Set PathPresentationMode to <" + mode + "> : WayPoint contains no points.");
        }
    }

    public PathPresentationMode getPathPresentationMode() {
        return this.pathPresentationMode;
    }

    public Point3d getCentroid() {
        if (this.centroid == null) {
            this.centroid = new Point3d(0.0, 0.0, 0.0);
            if (((WayPointPath)this.getTopologyNode()).getPoints().size() > 0) {
                for (CartesianPositionCoordinates point : ((WayPointPath)this.getTopologyNode()).getPoints()) {
                    this.centroid.x += point.getX();
                    this.centroid.y += point.getY();
                    this.centroid.z += point.getZ();
                }
                this.centroid.scale(1.0 / (double)((WayPointPath)this.getTopologyNode()).getPoints().size());
            }
        }
        return this.centroid;
    }

    public void setPointSize(final int pointSize) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (WayPointPathJME3Object.this.pathPointsGeometry != null && WayPointPathJME3Object.this.pathPointsGeometry.getMesh() != null) {
                    WayPointPathJME3Object.this.pathPointsGeometry.getMesh().setPointSize((float)pointSize);
                }
                return null;
            }
        });
    }

    public void setEndPointsRadius(float endPointsRadius) {
        if (endPointsRadius >= 0.0f) {
            Logger.info("Setting end point radius to <" + endPointsRadius + ">.");
            this.endPointSize = endPointsRadius;
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (((WayPointPath)WayPointPathJME3Object.this.getTopologyNode()).getPoints().size() > 1) {
                        if (WayPointPathJME3Object.this.startPointNode != null && WayPointPathJME3Object.this.getAttachmentNode().getChildren().contains(WayPointPathJME3Object.this.startPointNode)) {
                            WayPointPathJME3Object.this.getAttachmentNode().detachChild((Spatial)WayPointPathJME3Object.this.startPointNode);
                            WayPointPathJME3Object.this.startPointNode = WayPointPathJME3Object.this.createStartPointNode();
                            WayPointPathJME3Object.this.getAttachmentNode().attachChild((Spatial)WayPointPathJME3Object.this.startPointNode);
                        }
                        if (WayPointPathJME3Object.this.endPointNode != null && WayPointPathJME3Object.this.getAttachmentNode().getChildren().contains(WayPointPathJME3Object.this.endPointNode)) {
                            WayPointPathJME3Object.this.getAttachmentNode().detachChild((Spatial)WayPointPathJME3Object.this.endPointNode);
                            WayPointPathJME3Object.this.endPointNode = WayPointPathJME3Object.this.createEndPointNode();
                            WayPointPathJME3Object.this.getAttachmentNode().attachChild((Spatial)WayPointPathJME3Object.this.endPointNode);
                        }
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Failed to set end point radius to <" + endPointsRadius + ">! Radius cannot be negative.");
        }
    }

    public float getEndPointsRadius() {
        return this.endPointSize;
    }

    public void setColor(RGBA rgb) {
        Logger.info("setColor(" + rgb + ")");
        this.lineColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Material mat;
                if (WayPointPathJME3Object.this.pathLinesGeometry != null && WayPointPathJME3Object.this.pathLinesGeometry.getMesh() != null) {
                    mat = WayPointPathJME3Object.this.createLineMaterial();
                    mat.setColor("Color", WayPointPathJME3Object.this.lineColor);
                    WayPointPathJME3Object.this.pathLinesGeometry.setMaterial(mat);
                }
                if (WayPointPathJME3Object.this.pathPointsGeometry != null && WayPointPathJME3Object.this.pathPointsGeometry.getMesh() != null) {
                    mat = WayPointPathJME3Object.this.createLineMaterial();
                    mat.setColor("Color", WayPointPathJME3Object.this.lineColor);
                    WayPointPathJME3Object.this.pathPointsGeometry.setMaterial(mat);
                }
                return null;
            }
        });
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.pathLinesGeometry);
        geometries.add(this.pathPointsGeometry);
        return geometries;
    }

    private void updateGeometry(WayPointPath wayPointPath) {
        if (this.pathLinesGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.pathLinesGeometry);
        }
        if (this.pathPointsGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.pathPointsGeometry);
        }
        if (this.startPointNode != null) {
            this.getAttachmentNode().detachChild((Spatial)this.startPointNode);
        }
        if (this.endPointNode != null) {
            this.getAttachmentNode().detachChild((Spatial)this.endPointNode);
        }
        this.pathPointsGeometry = this.createPointsGeometry();
        this.pathLinesGeometry = this.createLineGeometry();
        if (((WayPointPath)this.getTopologyNode()).getPoints().size() > 0) {
            switch (this.pathPresentationMode.getValue()) {
                case 1: {
                    this.getAttachmentNode().attachChild((Spatial)this.pathLinesGeometry);
                    break;
                }
                case 0: {
                    this.getAttachmentNode().attachChild((Spatial)this.pathPointsGeometry);
                    break;
                }
                case 2: {
                    this.getAttachmentNode().attachChild((Spatial)this.pathLinesGeometry);
                    this.getAttachmentNode().attachChild((Spatial)this.pathPointsGeometry);
                }
            }
            if (((WayPointPath)this.getTopologyNode()).getPoints().size() > 1) {
                this.startPointNode = this.createStartPointNode();
                this.getAttachmentNode().attachChild((Spatial)this.startPointNode);
            }
            if (((WayPointPath)this.getTopologyNode()).getPoints().size() > 2) {
                this.endPointNode = this.createEndPointNode();
                this.getAttachmentNode().attachChild((Spatial)this.endPointNode);
            }
        }
    }

    private Geometry createLineGeometry() {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        int index = 0;
        for (CartesianPositionCoordinates point : ((WayPointPath)this.getTopologyNode()).getPoints()) {
            verticesList.add(new Vector3f((float)point.getX(), (float)point.getY(), (float)point.getZ()));
            if (index > 0) {
                indexesList.add(new Integer(index - 1));
                indexesList.add(new Integer(index));
            }
            ++index;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        Geometry geometry = null;
        geometry = ((WayPointPath)this.getTopologyNode()).getNodeId() != null ? new Geometry(((WayPointPath)this.getTopologyNode()).getNodeId(), mesh) : new Geometry("WayPointPath", mesh);
        geometry.setMaterial(this.createLineMaterial());
        return geometry;
    }

    private Geometry createPointsGeometry() {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        int index = 0;
        for (CartesianPositionCoordinates point : ((WayPointPath)this.getTopologyNode()).getPoints()) {
            verticesList.add(new Vector3f((float)point.getX(), (float)point.getY(), (float)point.getZ()));
            indexesList.add(new Integer(index));
            ++index;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Points);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        Geometry geometry = null;
        geometry = ((WayPointPath)this.getTopologyNode()).getNodeId() != null ? new Geometry(((WayPointPath)this.getTopologyNode()).getNodeId(), mesh) : new Geometry("WayPointPath", mesh);
        geometry.setMaterial(this.createLineMaterial());
        return geometry;
    }

    private Material createLineMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        if (this.lineColor == null) {
            mat.setColor("Color", DEFAULT_POINT_COLOR.clone());
        } else {
            mat.setColor("Color", this.lineColor);
        }
        return mat;
    }

    private com.jme3.scene.Node createStartPointNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Start Point");
        node.setLocalTranslation(JME3Utilities.convertToVector3f((Tuple3d)((WayPointPath)this.getTopologyNode()).getStartPoint().asPoint3d()));
        Sphere sphere = new Sphere(10, 36, this.endPointSize);
        Geometry geometry = new Geometry("Start Point Geometry", (Mesh)sphere);
        geometry.setMaterial(this.createStartPointMaterial());
        node.attachChild((Spatial)geometry);
        return node;
    }

    private Material createStartPointMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", DEFAULT_START_POINT_COLOR);
        return mat;
    }

    private com.jme3.scene.Node createEndPointNode() {
        com.jme3.scene.Node node = new com.jme3.scene.Node("End Point");
        node.setLocalTranslation(JME3Utilities.convertToVector3f((Tuple3d)((WayPointPath)this.getTopologyNode()).getEndPoint().asPoint3d()));
        Sphere sphere = new Sphere(10, 36, this.endPointSize);
        Geometry geometry = new Geometry("End Point Geometry", (Mesh)sphere);
        geometry.setMaterial(this.createEndPointMaterial());
        node.attachChild((Spatial)geometry);
        return node;
    }

    private Material createEndPointMaterial() {
        Material mat = new Material(this.getApplication().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setColor("Color", DEFAULT_END_POINT_COLOR);
        return mat;
    }

    private void addPoint(CartesianPositionCoordinates point) {
        Job job = new Job("WayPointPathJME3Object : Updating geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                WayPointPathJME3Object.this.requestUpdate();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        point.eAdapters().add((Object)this.getPointsListener());
    }

    private void addPoints(List<CartesianPositionCoordinates> points) {
        Job job = new Job("WayPointPathJME3Object : Updating geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                WayPointPathJME3Object.this.requestUpdate();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        for (CartesianPositionCoordinates point : points) {
            point.eAdapters().add((Object)this.getPointsListener());
        }
    }

    private void removePoint(CartesianPositionCoordinates point) {
        Job job = new Job("WayPointPathJME3Object : Updating geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                WayPointPathJME3Object.this.requestUpdate();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        point.eAdapters().remove((Object)this.getPointsListener());
    }

    private void removePoints(List<CartesianPositionCoordinates> points) {
        Job job = new Job("WayPointPathJME3Object : Updating geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                WayPointPathJME3Object.this.requestUpdate();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        for (CartesianPositionCoordinates point : points) {
            point.eAdapters().remove((Object)this.getPointsListener());
        }
    }

    private Adapter getPointsListener() {
        if (this.modelListener == null) {
            this.modelListener = new AdapterImpl(){

                /*
                 * Enabled aggressive block sorting
                 */
                public void notifyChanged(Notification notification) {
                    if (notification.getNotifier() instanceof WayPointPath) {
                        int featureId = notification.getFeatureID(WayPointPath.class);
                        switch (featureId) {
                            case 0: {
                                int eventType = notification.getEventType();
                                switch (eventType) {
                                    case 3: {
                                        if (!(notification.getNewValue() instanceof CartesianPositionCoordinates)) return;
                                        CartesianPositionCoordinates point = (CartesianPositionCoordinates)notification.getNewValue();
                                        WayPointPathJME3Object.this.addPoint(point);
                                        return;
                                    }
                                    case 5: {
                                        List added = (List)notification.getNewValue();
                                        WayPointPathJME3Object.this.addPoints(added);
                                        return;
                                    }
                                    case 4: {
                                        if (!(notification.getOldValue() instanceof CartesianPositionCoordinates)) return;
                                        CartesianPositionCoordinates point = (CartesianPositionCoordinates)notification.getOldValue();
                                        WayPointPathJME3Object.this.removePoint(point);
                                        return;
                                    }
                                    case 6: {
                                        List removed = (List)notification.getOldValue();
                                        WayPointPathJME3Object.this.removePoints(removed);
                                        return;
                                    }
                                    case 7: {
                                        Job job = new Job("WayPointPathJME3Object : Updating geometry"){

                                            protected IStatus run(IProgressMonitor monitor) {
                                                WayPointPathJME3Object.this.requestUpdate();
                                                return Status.OK_STATUS;
                                            }
                                        };
                                        job.schedule();
                                        return;
                                    }
                                }
                            }
                        }
                        return;
                    }
                    if (!(notification.getNotifier() instanceof CartesianPositionCoordinates)) return;
                    int featureId = notification.getFeatureID(CartesianPositionCoordinates.class);
                    switch (featureId) {
                        case 0: 
                        case 1: 
                        case 2: {
                            Job job = new Job("WayPointPathJME3Object : Updating geometry"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    WayPointPathJME3Object.this.requestUpdate();
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                            return;
                        }
                    }
                }
            };
        }
        return this.modelListener;
    }
}

