/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HistorySizeManagementPolicy implements Enumerator
{
    CLEAR_OLDEST(0, "CLEAR_OLDEST", "Clear Oldest"),
    UNIFORM_RESAMPLING(1, "UNIFORM_RESAMPLING", "Uniform Re-Sampling");

    public static final int CLEAR_OLDEST_VALUE = 0;
    public static final int UNIFORM_RESAMPLING_VALUE = 1;
    private static final HistorySizeManagementPolicy[] VALUES_ARRAY;
    public static final List<HistorySizeManagementPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HistorySizeManagementPolicy[]{CLEAR_OLDEST, UNIFORM_RESAMPLING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HistorySizeManagementPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HistorySizeManagementPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HistorySizeManagementPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HistorySizeManagementPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HistorySizeManagementPolicy get(int value) {
        switch (value) {
            case 0: {
                return CLEAR_OLDEST;
            }
            case 1: {
                return UNIFORM_RESAMPLING;
            }
        }
        return null;
    }

    private HistorySizeManagementPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

