/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFacade;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFactory;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.ValueSource;
import org.eclipse.apogy.addons.monitoring.ValueSourceList;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSourceListComposite<RootEObject extends ValueSourceList, ResolvedEObject extends ValueSourceList, ItemObject extends ValueSource<?>>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    private static final Logger Logger = LoggerFactory.getLogger(ValueSourceListComposite.class);

    public ValueSourceListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE_LIST__VALUE_SOURCES, settings);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof ValueSource) {
            ValueSource valueSource = (ValueSource)selection.getFirstElement();
            this.doSelectValueSource(valueSource);
        }
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createSelectValueSourceButton(parent, style);
        this.createUnSelectValueSourceButton(parent, style);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ValueSource) {
                    ValueSource valueSource = (ValueSource)element;
                    return valueSource.getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                if (element instanceof ValueSource) {
                    ValueSource valueSource = (ValueSource)element;
                    return valueSource.getDescription();
                }
                return "";
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn typeColumn = new TreeViewerColumn(viewer, 0);
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setAlignment(0x1000000);
        typeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ValueSource) {
                    ValueSource valueSource = (ValueSource)element;
                    return valueSource.eClass().getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                if (element instanceof ValueSource) {
                    ValueSource valueSource = (ValueSource)element;
                    return valueSource.eClass().getInstanceClassName();
                }
                return "";
            }
        });
        typeColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }

    protected void doNew() {
        ValueSourceList notifierList = ApogyAddonsMonitoringFacade.INSTANCE.getValueSourceList();
        if (notifierList == null) {
            notifierList = ApogyAddonsMonitoringFactory.eINSTANCE.createValueSourceList();
            InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)invocatorSession.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)notifierList, true);
            this.refreshViewer();
        }
        AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
        settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)notifierList, null, (ETypedElement)ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE_LIST__VALUE_SOURCES));
        EObjectWizard wizard = new EObjectWizard((EObject)notifierList, null, ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE_LIST__VALUE_SOURCES, ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        if (wizard.getCreatedEObject() instanceof ValueSource) {
            ValueSource valueSource = (ValueSource)wizard.getCreatedEObject();
            try {
                valueSource.initialise();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.refreshViewer();
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)valueSource), true);
            this.doSelectValueSource(valueSource);
        }
        this.refreshViewer();
    }

    protected Button createDeleteButton(Composite parent, int style) {
        Button btnDelete = ValueSourceListComposite.createButton((Composite)parent, (int)0, (String)"Delete", e -> {
            MessageDialog dialog;
            String message = "";
            List items = this.getCurrentSelection().toList();
            List<EObject> crossReferencers = this.getCrossReferencers(items);
            int size = items.size();
            message = "Are you sure to delete " + (size > 1 ? "these " + size + " value sources." : "this value source?");
            if (!crossReferencers.isEmpty()) {
                message = String.valueOf(message) + "It is referenced by the following : \n\n";
                for (EObject item : crossReferencers) {
                    String className = item.eClass().getName();
                    message = String.valueOf(message) + " - ";
                    message = item instanceof Named ? String.valueOf(message) + ((Named)item).getName() : String.valueOf(message) + item.hashCode();
                    message = String.valueOf(message) + " (" + className + ")\n";
                }
            }
            if ((dialog = new MessageDialog(null, "Delete the selected value Source(s)", null, message, 3, new String[]{"Yes", "No"}, 1)).open() == 0) {
                BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                    for (ValueSource item : items) {
                        this.doDelete(item);
                    }
                });
            }
            this.refreshViewer();
        });
        this.createDeleteButtonBindings(btnDelete);
        return btnDelete;
    }

    protected void doDelete(ValueSource valueSource) {
        try {
            try {
                valueSource.dispose();
            }
            catch (Exception e) {
                Logger.error("Failed to dispose of value source <" + valueSource.getName() + ">!", (Throwable)e);
            }
            ApogyCommonEMFFacade.INSTANCE.nullifyAllCrossReferenceToEObject((EObject)valueSource);
            ApogyCommonTransactionFacade.INSTANCE.basicRemove(this.getRootEObject(), this.getEStructuralFeature(), (Object)valueSource, true);
            if (this.getViewer().getTree().getItemCount() > 0) {
                Object obj = this.getViewer().getTree().getItem(0).getData();
                this.getViewer().setSelection((ISelection)new StructuredSelection(obj), true);
                this.selectionChanged((IStructuredSelection)new StructuredSelection(obj));
            } else {
                this.selectionChanged((IStructuredSelection)new StructuredSelection());
            }
            this.refreshViewer();
            Logger.info("Deleted value source <" + valueSource.getName() + ">.");
        }
        catch (Exception e) {
            Logger.error("Failed to delete value source !", (Throwable)e);
        }
    }

    protected Button createSelectValueSourceButton(Composite parent, int style) {
        Button button = ValueSourceListComposite.createButton((Composite)parent, (int)0, (String)"Select Value Source", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doSelectValueSource((ValueSource)this.getViewer().getStructuredSelection().getFirstElement());
            this.refreshViewer();
        }));
        this.createSelectValueSourceButtonBindings(button);
        return button;
    }

    protected void createSelectValueSourceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doSelectValueSource(ValueSource<?> valueSource) {
    }

    protected Button createUnSelectValueSourceButton(Composite parent, int style) {
        Button button = ValueSourceListComposite.createButton((Composite)parent, (int)0, (String)"Un Select Value Source", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doUnSelectValueSource();
            this.refreshViewer();
        }));
        return button;
    }

    protected void doUnSelectValueSource() {
    }

    protected List<EObject> getCrossReferencers(List<ItemObject> items) {
        ArrayList<EObject> crossReferencers = new ArrayList<EObject>();
        for (ValueSource item : items) {
            crossReferencers.addAll(ApogyCommonEMFFacade.INSTANCE.getCrossReferencerToEObject((EObject)item));
        }
        return crossReferencers;
    }
}

