/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.views;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.ui.composites.ValueSourceComposite;
import org.eclipse.apogy.common.e4.ui.ApogyCommonE4UIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.EObjectCompositeSettings;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class NotifierValueSourcePart
extends AbstractSessionPart<ApogyNotifier> {
    private ValueSourceComposite<ApogyNotifier, ApogyNotifier> notificationEffectComposite;
    @Inject
    public EPartService ePartService;
    @Inject
    public ESelectionService selectionService;
    @Inject
    public MPart mPart;

    @Inject
    @PostConstruct
    public void postConstruct() {
        try {
            IStructuredSelection iStructuredSelection;
            String parentPart = this.getParentPartId();
            Object value = this.getParentSelection(parentPart);
            if (value instanceof ApogyNotifier) {
                ApogyNotifier apogyNotifier = (ApogyNotifier)value;
                this.setContent((EObject)apogyNotifier);
            } else if (value instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)value).isEmpty() && iStructuredSelection.getFirstElement() instanceof ApogyNotifier) {
                ApogyNotifier apogyNotifier = (ApogyNotifier)iStructuredSelection.getFirstElement();
                this.setContent((EObject)apogyNotifier);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") ApogyNotifier notifier, EPartService ePartService) {
        String parentPart = this.getParentPartId();
        if (parentPart != null && ApogyCommonE4UIFacade.INSTANCE.isActive(ePartService, parentPart)) {
            ApogyNotifier selectedApogyNotifier = null;
            if (this.selectionService.getSelection(parentPart) instanceof ApogyNotifier) {
                selectedApogyNotifier = (ApogyNotifier)this.selectionService.getSelection(parentPart);
            }
            if (selectedApogyNotifier != null) {
                this.setContent((EObject)selectedApogyNotifier);
            } else {
                this.setContent(null);
            }
        }
    }

    protected void doSetContent(ApogyNotifier rootEObject) {
        this.notificationEffectComposite.setRootEObject((EObject)rootEObject);
    }

    protected void createComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setDetailSectionDisplayed(true);
        settings.setButtonsSectionDisplayed(true);
        this.notificationEffectComposite = new ValueSourceComposite(parent, style, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__VALUE_SOURCE, (EObjectCompositeSettings)settings);
    }

    protected String getParentPartId() {
        return (String)this.mPart.getPersistedState().get("APOGY_NOTIFIER_PROVIDER_PART_ID");
    }
}

