/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.util.Iterator;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.NotificationCondition;
import org.eclipse.apogy.addons.monitoring.NotificationConditionLogicalOperation;
import org.eclipse.apogy.addons.monitoring.NotificationEffect;
import org.eclipse.apogy.addons.monitoring.ValueSource;
import org.eclipse.apogy.addons.monitoring.impl.ApogyNotifierImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.progress.UIJob;

public class ApogyNotifierCustomImpl
extends ApogyNotifierImpl {
    protected boolean initialised = false;
    private Adapter valueSourceAdapter = null;

    @Override
    public void initialise() {
        this.initialised = true;
        for (NotificationEffect effect : this.getEffects()) {
            try {
                effect.initialise();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (NotificationCondition condition : this.getConditions()) {
            try {
                condition.initialise();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void forceRefresh() {
        this.processNewValue(this.getValueSource().getCurrentValue());
    }

    @Override
    public void dispose() {
        if (this.getValueSource() != null) {
            this.getValueSource().eAdapters().remove((Object)this.getValueSourceAdapter());
        }
        for (NotificationEffect effect : this.getEffects()) {
            try {
                effect.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (NotificationCondition condition : this.getConditions()) {
            try {
                condition.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setValueSource(ValueSource<?> newValueSource) {
        if (this.getValueSource() != null) {
            this.getValueSource().eAdapters().remove((Object)this.getValueSourceAdapter());
        }
        super.setValueSource(newValueSource);
        if (newValueSource != null) {
            newValueSource.eAdapters().add((Object)this.getValueSourceAdapter());
            if (this.initialised) {
                this.processNewValue(newValueSource.getCurrentValue());
            }
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        super.setEnabled(newEnabled);
        if (newEnabled && this.getValueSource() != null) {
            if (this.initialised) {
                this.processNewValue(this.getValueSource().getCurrentValue());
            }
        } else {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__TRIGGERED, (Object)false, true);
            this.deactivateEffects();
        }
    }

    protected void activateEffects(final Object newValue) {
        UIJob effectsJob = new UIJob("Activate Effects"){

            public IStatus runInUIThread(IProgressMonitor arg0) {
                for (NotificationEffect effect : ApogyNotifierCustomImpl.this.getEffects()) {
                    if (!effect.isEnabled()) continue;
                    try {
                        effect.activate(ApogyNotifierCustomImpl.this, newValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        effectsJob.schedule();
    }

    protected void processNewValue(Object newValue) {
        if (this.isEnabled()) {
            boolean valid = false;
            if (this.getConditions().size() > 0) {
                Iterator it;
                if (this.getConditionLogicalOperator() == NotificationConditionLogicalOperation.OR) {
                    it = this.getConditions().iterator();
                    while (!valid && it.hasNext()) {
                        NotificationCondition condition = (NotificationCondition)it.next();
                        try {
                            boolean conditionValid = condition.evaluate(newValue);
                            if (!conditionValid) continue;
                            valid = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (this.getConditionLogicalOperator() == NotificationConditionLogicalOperation.AND) {
                    valid = true;
                    it = this.getConditions().iterator();
                    while (valid && it.hasNext()) {
                        NotificationCondition condition = (NotificationCondition)it.next();
                        try {
                            valid = condition.evaluate(newValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                valid = true;
            }
            boolean activateEffects = false;
            activateEffects = this.isTriggerOnConditionPositiveGoingEdgeOnly() ? !this.isTriggered() && valid : valid;
            if (activateEffects) {
                this.activateEffects(newValue);
            } else {
                this.deactivateEffects();
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__TRIGGERED, (Object)valid, true);
        }
    }

    protected void deactivateEffects() {
        UIJob effectsJob = new UIJob("Deactivate Effects"){

            public IStatus runInUIThread(IProgressMonitor arg0) {
                for (NotificationEffect effect : ApogyNotifierCustomImpl.this.getEffects()) {
                    if (!effect.isEnabled()) continue;
                    try {
                        effect.deactivate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        effectsJob.schedule();
    }

    private Adapter getValueSourceAdapter() {
        if (this.valueSourceAdapter == null) {
            this.valueSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(ValueSource.class) == 2) {
                        ApogyNotifierCustomImpl.this.processNewValue(msg.getNewValue());
                    }
                }
            };
        }
        return this.valueSourceAdapter;
    }
}

