/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import org.eclipse.apogy.addons.monitoring.Alarm;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.impl.PopUpMessageNotificationEffectImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PopUpMessageNotificationEffectCustomImpl
extends PopUpMessageNotificationEffectImpl {
    private Dialog dialog;

    @Override
    public void activate(ApogyNotifier notifier, Object newValue) {
        String message;
        if (this.dialog != null) {
            this.dialog.close();
        }
        if ((message = this.replaceValueStringTokenWithValue(this.getMessage(), newValue)) == null) {
            message = "";
        }
        String title = "Notification";
        if (notifier.getName() != null) {
            title = String.valueOf(title) + " : " + notifier.getName();
        }
        this.dialog = notifier instanceof Alarm ? new CustomDialog(Display.getDefault().getActiveShell(), title, message, notifier) : new CustomDialog(Display.getDefault().getActiveShell(), title, message, notifier);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    @Override
    public void deactivate() {
        if (this.dialog != null) {
            try {
                this.dialog.close();
            }
            catch (Exception exception) {}
        }
    }

    public class CustomDialog
    extends Dialog {
        private String title;
        private String message;
        private ApogyNotifier notifier;

        public CustomDialog(Shell parentShell, String title, String message, ApogyNotifier notifier) {
            super(parentShell);
            this.title = title;
            this.message = message;
            this.notifier = notifier;
            this.setShellStyle(2145);
            this.setBlockOnOpen(false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(2, false));
            Label imageLabel = new Label(container, 0);
            GridData imageLabelGd = new GridData(16384, 128, false, false);
            imageLabel.setLayoutData((Object)imageLabelGd);
            Label text = new Label(container, 0);
            text.setAlignment(0x1000000);
            text.setText(this.message);
            text.setToolTipText(this.message);
            GridData textGridData = new GridData(4, 0x1000000, true, true);
            textGridData.heightHint = 200;
            textGridData.minimumHeight = 200;
            text.setLayoutData((Object)textGridData);
            Image image = null;
            image = this.notifier instanceof Alarm ? Display.getDefault().getSystemImage(1) : Display.getDefault().getSystemImage(2);
            imageLabel.setImage(image);
            return container;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            if (this.notifier instanceof Alarm) {
                this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
                this.createButton(parent, 10, "ACK", true);
            } else {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.title);
        }

        protected Point getInitialSize() {
            return new Point(400, 200);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                super.buttonPressed(buttonId);
            } else if (buttonId == 10) {
                try {
                    ((Alarm)this.notifier).ack();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.close();
            }
            PopUpMessageNotificationEffectCustomImpl.this.dialog = null;
        }
    }
}

