/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import org.eclipse.apogy.addons.powersystems.AbstractInputElement;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.MutipleInputsElement;
import org.eclipse.apogy.addons.powersystems.SingleInputElement;
import org.eclipse.apogy.addons.powersystems.impl.EnergyStorageImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EnergyStorageCustomImpl
extends EnergyStorageImpl {
    protected long lastChangeTime = -1L;

    @Override
    public boolean isPowerStateValid() {
        boolean result = true;
        result = this.getCurrentPowerFlow() < 0.0 ? (result &= this.getCurrentPowerFlow() <= this.getMaximumPowerInput()) : (result &= Math.abs(this.getCurrentPowerFlow()) <= this.getMaximumPowerOuput());
        return result &= this.getStoredEnergy() <= this.getStorageCapacity();
    }

    @Override
    public void update(Date date) {
        double newCurrentBatteryEnergy;
        long newTime = date.getTime();
        double deltaTime = 0.0;
        if (this.lastChangeTime > 0L && (deltaTime = 1.0 * (double)(newTime - this.lastChangeTime) / 1000.0) < 0.0) {
            deltaTime = 0.0;
        }
        this.lastChangeTime = newTime;
        double newPowerFlow = this.getCurrentPowerFlow();
        if (Double.isNaN(newPowerFlow)) {
            System.out.println("ERROR");
        }
        double totalEnergyCapacity = this.getStorageCapacity();
        double currentBatteryEnergy = this.getStoredEnergy();
        double energyDelta = 0.0;
        if (newPowerFlow > 0.0) {
            if (this.getCurrentPowerFlow() > this.getMaximumPowerInput()) {
                newPowerFlow = this.getMaximumPowerInput();
            }
        } else if (newPowerFlow < 0.0 && Math.abs(this.getCurrentPowerFlow()) > this.getMaximumPowerOuput()) {
            newPowerFlow = -this.getMaximumPowerOuput();
        }
        if ((newCurrentBatteryEnergy = currentBatteryEnergy + (energyDelta = this.computeStorageEnergyDelta(newPowerFlow, deltaTime))) >= totalEnergyCapacity) {
            newCurrentBatteryEnergy = totalEnergyCapacity;
        } else if (newCurrentBatteryEnergy <= 0.0) {
            newCurrentBatteryEnergy = 0.0;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__CURRENT_POWER_FLOW, (Object)newPowerFlow, true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__STORED_ENERGY, (Object)newCurrentBatteryEnergy, true);
    }

    @Override
    public void setCurrentPowerFlow(double newCurrentPowerFlow) {
        if (Double.isNaN(newCurrentPowerFlow)) {
            try {
                throw new RuntimeException("BAD");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.setCurrentPowerFlow(newCurrentPowerFlow);
        }
    }

    @Override
    public double getSoc() {
        double soc = this.getStoredEnergy() / this.getStorageCapacity() * 100.0;
        if (soc < 0.0) {
            soc = 0.0;
        }
        if (soc > 100.0) {
            soc = 100.0;
        }
        return soc;
    }

    @Override
    public void resetStoredEnergy(double soc) {
        if (soc < 0.0 || soc > 100.0) {
            throw new RuntimeException("Soca nedds to be between 0 and 100!");
        }
        double newStoredEnergy = this.getStorageCapacity() * (soc / 100.0);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__STORED_ENERGY, (Object)newStoredEnergy, true);
    }

    @Override
    public double storePower(double storedPower) {
        if (storedPower < 0.0) {
            throw new RuntimeException("Cannot stored negative power!");
        }
        double powerInputed = storedPower;
        double maximumInputPower = this.getMaximumPowerInput();
        if (storedPower > maximumInputPower) {
            powerInputed = maximumInputPower;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__CURRENT_POWER_FLOW, (Object)powerInputed, true);
        return powerInputed;
    }

    @Override
    public double drawPower(double requestedPower) {
        if (requestedPower < 0.0) {
            throw new RuntimeException("Cannot draw negative power!");
        }
        double powerDrawn = requestedPower;
        double maximumOutputPower = this.getMaximumPowerOuput();
        if (requestedPower > maximumOutputPower) {
            powerDrawn = maximumOutputPower;
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__CURRENT_POWER_FLOW, (Object)(-powerDrawn), true);
        return powerDrawn;
    }

    @Override
    public double getMaximumPowerInput() {
        if (this.getStoredEnergy() >= this.getStorageCapacity()) {
            return 0.0;
        }
        return super.getMaximumPowerInput();
    }

    @Override
    public double getMaximumPowerOuput() {
        if (this.getStoredEnergy() <= 0.0) {
            return 0.0;
        }
        return super.getMaximumPowerOuput();
    }

    @Override
    public void connectOutput(AbstractInputElement target) {
        if (this.getOutput() != null) {
            this.getOutput().disconnectInput(this);
        }
        this.setOutput(target);
        if (target instanceof SingleInputElement) {
            ((SingleInputElement)target).setInput(this);
        } else if (target instanceof MutipleInputsElement) {
            ((MutipleInputsElement)target).getInputs().add((Object)this);
        }
    }

    @Override
    public void disconnectOutput(AbstractInputElement target) {
        this.setOutput(null);
        if (target instanceof SingleInputElement) {
            ((SingleInputElement)target).setInput(null);
        } else if (target instanceof MutipleInputsElement) {
            ((MutipleInputsElement)target).getInputs().remove((Object)this);
        }
    }

    @Override
    public double computeStorageEnergyDelta(double powerFlow, double duration) {
        return powerFlow * duration;
    }
}

