/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.SolarCell;
import org.eclipse.apogy.addons.powersystems.SolarCellNode;
import org.eclipse.apogy.addons.powersystems.SolarPanel;
import org.eclipse.apogy.addons.powersystems.SolarPanelBinding;
import org.eclipse.apogy.addons.powersystems.SolarPanelNode;
import org.eclipse.apogy.addons.powersystems.impl.SolarPanelBindingImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.FeatureNodeAdapter;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.ITopologyViewer;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewer;
import org.eclipse.apogy.common.topology.util.NodeRelativePoseListener;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SolarPanelBindingCustomImpl
extends SolarPanelBindingImpl {
    private Adapter sessionAdapter = null;
    private Adapter worksiteAdapter = null;
    private NodeRelativePoseListener nodeRelativePoseListener;
    private List<SolarCellNode> cells = null;

    public AbstractTopologyBinding clone(Map<Node, Node> originalToCopyNodeMap) {
        SolarPanelBinding bindingCopy = (SolarPanelBinding)EcoreUtil.copy((EObject)this);
        SolarPanelNode solarPanelNodeCopy = (SolarPanelNode)originalToCopyNodeMap.get(this.getSolarPanelNode());
        bindingCopy.setSolarPanelNode(solarPanelNodeCopy);
        return bindingCopy;
    }

    @Override
    public void setSolarPanelNode(SolarPanelNode newSolarPanelNode) {
        super.setSolarPanelNode(newSolarPanelNode);
        this.getNodeRelativePoseListener().setToNode((Node)newSolarPanelNode);
    }

    public void bind() {
        super.bind();
        this.getNodeRelativePoseListener().setFromNode((Node)ApogyCoreEnvironmentFacade.INSTANCE.getActiveSun());
        this.getNodeRelativePoseListener().setToNode((Node)this.getSolarPanelNode());
        if (ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite() != null) {
            ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite().eAdapters().add((Object)this.getWorksiteAdapter());
        }
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getSessionAdapter());
    }

    public void unbind() {
        if (ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite() != null) {
            ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite().eAdapters().remove((Object)this.getWorksiteAdapter());
        }
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().remove((Object)this.getWorksiteAdapter());
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().remove((Object)this.getSessionAdapter());
        if (this.nodeRelativePoseListener != null) {
            this.nodeRelativePoseListener.dispose();
        }
        super.unbind();
    }

    public Class<?> getSupportedFeatureType() {
        return SolarPanel.class;
    }

    protected void valueChanged(Object newValue) {
        if (newValue instanceof SolarPanelNode) {
            SolarPanelNode solarPanelNode = (SolarPanelNode)newValue;
            this.getNodeRelativePoseListener().setToNode((Node)solarPanelNode);
        }
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(FeatureNodeAdapter.class) == 2) {
                        if (notification.getOldValue() instanceof SolarPanel) {
                            SolarPanel oldSolarPanel = (SolarPanel)notification.getOldValue();
                            oldSolarPanel.eAdapters().remove((Object)SolarPanelBindingCustomImpl.this.getAdapter());
                        }
                        if (notification.getNewValue() instanceof SolarPanel) {
                            SolarPanel newSolarPanel = (SolarPanel)notification.getNewValue();
                            newSolarPanel.eAdapters().add((Object)SolarPanelBindingCustomImpl.this.getAdapter());
                            SolarPanelBindingCustomImpl.this.valueChanged(newSolarPanel);
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected SolarPanel getSolarPanel() {
        return (SolarPanel)ApogyCommonEMFFacade.INSTANCE.resolve(this.getSource(), this.getFeatureNode());
    }

    protected List<SolarCellNode> getCells() {
        if (this.cells == null) {
            this.cells = new ArrayList<SolarCellNode>();
            for (Node node : this.getSolarPanelNode().getChildren()) {
                if (!(node instanceof SolarCellNode)) continue;
                this.cells.add((SolarCellNode)node);
            }
        }
        return this.cells;
    }

    protected SolarCell getsolarCellForSolarCellNode(SolarCellNode solarCellNode) {
        return this.getSolarPanel().getSolarCellByName(solarCellNode.getNodeId());
    }

    protected NodeRelativePoseListener getNodeRelativePoseListener() {
        if (this.nodeRelativePoseListener == null) {
            this.nodeRelativePoseListener = new NodeRelativePoseListener(){

                public void relativePoseChanged(Matrix4d newPose) {
                    if (SolarPanelBindingCustomImpl.this.isBinded()) {
                        SolarPanelBindingCustomImpl.this.update();
                    }
                }
            };
        }
        return this.nodeRelativePoseListener;
    }

    protected void update() {
        try {
            if (this.getSolarPanel() != null) {
                Tuple3d panelSunVector = ApogyCoreEnvironmentFacade.INSTANCE.getSunVector((Node)this.getSolarPanelNode());
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.getSolarPanel(), (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_PANEL__SUN_INCIDENCE_VECTOR, (Object)panelSunVector, true);
                double sunIrradiance = 0.0;
                Worksite currentWorksite = (Worksite)ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite();
                if (currentWorksite != null) {
                    sunIrradiance = currentWorksite.getSunIrradiance();
                }
                for (SolarCellNode solarCellNode : this.getCells()) {
                    double sunIncidenceAngle;
                    SolarCell solarCell = this.getsolarCellForSolarCellNode(solarCellNode);
                    if (solarCell == null) continue;
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)solarCell, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_CELL__SOLAR_ILLUMINATION, (Object)sunIrradiance, true);
                    Tuple3d cellSunVector = ApogyCoreEnvironmentFacade.INSTANCE.getSunVector((Node)solarCellNode);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)solarCell, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_CELL__SUN_INCIDENCE_VECTOR, (Object)cellSunVector, true);
                    boolean isSolarCellInShadow = false;
                    if (sunIrradiance > 0.0 && (sunIncidenceAngle = solarCell.getSunIncidenceAngle()) >= 0.0 && sunIncidenceAngle <= Math.toRadians(90.0)) {
                        isSolarCellInShadow = this.isSolarCellInShadow(solarCellNode, cellSunVector);
                    }
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)solarCell, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_CELL__SHADOWED, (Object)isSolarCellInShadow, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isSolarCellInShadow(SolarCellNode solarCellNode, Tuple3d cellSunVector) {
        boolean shadowed = false;
        if (!Activator.getTopologyViewerRegistry().getITopologyViewers().isEmpty()) {
            try {
                ITopologyViewer iTopologyViewer = (ITopologyViewer)Activator.getTopologyViewerRegistry().getITopologyViewers().get(0);
                if (iTopologyViewer instanceof TopologyViewer) {
                    TopologyViewer topologyViewer = (TopologyViewer)iTopologyViewer;
                    Matrix4d cellPose = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)solarCellNode);
                    Vector3d origin = new Vector3d();
                    cellPose.get(origin);
                    Matrix4d sunPose = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)ApogyCoreEnvironmentFacade.INSTANCE.getActiveSun());
                    Vector3d sunPosition = new Vector3d();
                    sunPose.get(sunPosition);
                    Vector3d z = new Vector3d(sunPosition);
                    z.sub((javax.vecmath.Tuple3d)origin);
                    z.normalize();
                    Set hits = topologyViewer.getIRenderEngineDelegate().getIntersection(origin, z);
                    Iterator it = hits.iterator();
                    while (it.hasNext() && !shadowed) {
                        Node node = (Node)it.next();
                        if (node == solarCellNode || node == ApogyCoreEnvironmentFacade.INSTANCE.getActiveSun() || node == this.getSolarPanelNode() || node instanceof StarField) continue;
                        shadowed = true;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return shadowed;
    }

    protected Adapter getWorksiteAdapter() {
        if (this.worksiteAdapter == null) {
            this.worksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    block5: {
                        block4: {
                            AbstractWorksite newSite;
                            if (!(notification.getNotifier() instanceof ApogyCoreEnvironmentFacade)) break block4;
                            int featureId = notification.getFeatureID(ApogyCoreEnvironmentFacade.class);
                            if (featureId != 1) break block5;
                            AbstractWorksite old = (AbstractWorksite)notification.getOldValue();
                            if (old != null) {
                                old.eAdapters().remove((Object)SolarPanelBindingCustomImpl.this.getWorksiteAdapter());
                            }
                            if ((newSite = (AbstractWorksite)notification.getNewValue()) == null) break block5;
                            newSite.eAdapters().add((Object)SolarPanelBindingCustomImpl.this.getWorksiteAdapter());
                            SolarPanelBindingCustomImpl.this.update();
                            break block5;
                        }
                        if (notification.getNotifier() instanceof Worksite) {
                            Worksite worksite = (Worksite)notification.getNotifier();
                            int featureId = notification.getFeatureID(Worksite.class);
                            if (featureId == 4 && SolarPanelBindingCustomImpl.this.getSolarPanel() != null) {
                                double sunIrradiance = worksite.getSunIrradiance();
                                for (SolarCellNode solarCellNode : SolarPanelBindingCustomImpl.this.getCells()) {
                                    SolarCell solarCell = SolarPanelBindingCustomImpl.this.getsolarCellForSolarCellNode(solarCellNode);
                                    if (solarCell == null) continue;
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)solarCell, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_CELL__SOLAR_ILLUMINATION, (Object)Math.abs(sunIrradiance), true);
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.worksiteAdapter;
    }

    protected Adapter getSessionAdapter() {
        if (this.sessionAdapter == null) {
            this.sessionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    int featureId;
                    if (notification.getNotifier() instanceof ApogyCoreInvocatorFacade && (featureId = notification.getFeatureID(ApogyCoreInvocatorFacade.class)) == 0) {
                        SolarPanelBindingCustomImpl.this.getNodeRelativePoseListener().setFromNode((Node)ApogyCoreEnvironmentFacade.INSTANCE.getActiveSun());
                        SolarPanelBindingCustomImpl.this.getNodeRelativePoseListener().setToNode((Node)SolarPanelBindingCustomImpl.this.getSolarPanelNode());
                        SolarPanelBindingCustomImpl.this.update();
                    }
                }
            };
        }
        return this.sessionAdapter;
    }
}

