/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.impl.FeatureOfInterestPickingToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.ui.dialogs.FeatureOfInterestCreationDialog;
import org.eclipse.apogy.core.ui.dialogs.FeatureOfInterestListDialog;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOfInterestPickingToolCustomImpl
extends FeatureOfInterestPickingToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureOfInterestPickingToolImpl.class);

    @Override
    public void keyPressed(char key) {
        super.keyPressed(key);
        if (key == 'E' || key == 'e') {
            FeatureOfInterestListDialog dialog = new FeatureOfInterestListDialog(Display.getDefault().getActiveShell(), this.getFeatureOfInterestList());
            dialog.open();
        }
    }

    @Override
    public void mouseButtonClicked(MouseButton mouseButtonClicked) {
        if (mouseButtonClicked == MouseButton.RIGHT && this.getFeatureOfInterestList() != null && !this.getFeatureOfInterestList().getFeaturesOfInterest().isEmpty()) {
            final FeatureOfInterest foi = (FeatureOfInterest)this.getFeatureOfInterestList().getFeaturesOfInterest().get(this.getFeatureOfInterestList().getFeaturesOfInterest().size() - 1);
            if (this.isPromptBeforeDeletingFOI()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = "Please confirm you want to delete Feature Of Interest Named : " + foi.getName() + " ?";
                        if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Delete Feature Of Interest", (String)message)) {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)FeatureOfInterestPickingToolCustomImpl.this.getFeatureOfInterestList(), (EStructuralFeature)ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, (Object)foi, true);
                        }
                    }
                });
            } else {
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this.getFeatureOfInterestList(), (EStructuralFeature)ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, (Object)foi, true);
            }
        }
    }

    @Override
    public void selectionChanged(NodeSelection nodeSelection) {
        try {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__PICKED_NODE, (Object)nodeSelection.getSelectedNode());
            if (nodeSelection.getRelativeIntersectionPoint() != null) {
                Tuple3d point = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__PICK_RELATIVE_POSITION, (Object)point);
            } else {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__PICK_RELATIVE_POSITION, null);
            }
            if (nodeSelection.getAbsoluteIntersectionNormal() != null) {
                Tuple3d normal = ApogyCommonMathFacade.INSTANCE.createTuple3d((double)nodeSelection.getAbsoluteIntersectionNormal().x, (double)nodeSelection.getAbsoluteIntersectionNormal().y, (double)nodeSelection.getAbsoluteIntersectionNormal().z);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__PICK_ABSOLUTE_NORMAL, (Object)normal);
            } else {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__PICK_ABSOLUTE_NORMAL, null);
            }
            if (this.getPickedNode() != null && this.getFeatureOfInterestList() != null) {
                FeatureOfInterestCreationDialog mapSelectionDialog;
                Matrix4x4 pose = this.createFOIPose(this.getPickedNode(), this.getPickRelativePosition(), this.getPickAbsoluteNormal());
                Shell shell = Display.getCurrent().getActiveShell();
                FeaturesOfInterestMapLayer featuresOfInterestMapLayer = null;
                if (this.getFeatureOfInterestList() != null && this.getFeatureOfInterestList().eContainer() instanceof FeaturesOfInterestMapLayer) {
                    featuresOfInterestMapLayer = (FeaturesOfInterestMapLayer)this.getFeatureOfInterestList().eContainer();
                }
                if ((mapSelectionDialog = new FeatureOfInterestCreationDialog(shell, pose, featuresOfInterestMapLayer)).open() == 0) {
                    FeatureOfInterest foi = mapSelectionDialog.getFeatureOfInterest();
                    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getFeatureOfInterestList());
                    Command addCommand = AddCommand.create((EditingDomain)editingDomain, (Object)this.getFeatureOfInterestList(), (Object)ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, (Object)foi);
                    editingDomain.getCommandStack().execute(addCommand);
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Matrix4x4 createFOIPose(Node node, Tuple3d relativePosition, Tuple3d normal) {
        Matrix4x4 pose = null;
        Matrix4d transform = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(node);
        Point3d selectedPoint = new Point3d();
        if (relativePosition != null) {
            selectedPoint = new Point3d(relativePosition.asTuple3d());
        }
        transform.transform(selectedPoint);
        Tuple3d absolutePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)selectedPoint);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__PICK_ABSOLUTE_POSITION, (Object)absolutePosition);
        Matrix3x3 rotation = null;
        rotation = this.isUseLocationNormal() ? ApogyCommonMathFacade.INSTANCE.createMatrix3x3(this.createFOIOrientation(normal)) : ApogyCommonMathFacade.INSTANCE.createIdentityMatrix3x3();
        TransformNode t = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(selectedPoint.x, selectedPoint.y, selectedPoint.z, 0.0, 0.0, 0.0);
        t.setRotationMatrix(rotation);
        pose = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(t.asMatrix4d());
        return pose;
    }

    private Matrix3d createFOIOrientation(Tuple3d normal) {
        double theta;
        Matrix3d orientation = new Matrix3d();
        orientation.setIdentity();
        Vector3d planeOriginal = new Vector3d(0.0, 0.0, 1.0);
        Vector3d planeContact = new Vector3d(normal.asTuple3d());
        double dotProduct = planeContact.dot(planeOriginal);
        if (-1.0 <= dotProduct && dotProduct <= 1.0 && (theta = Math.acos(dotProduct)) != 0.0) {
            Vector3d cross = new Vector3d();
            cross.cross(planeContact, planeOriginal);
            cross.normalize();
            AxisAngle4d axisAngle = new AxisAngle4d(cross, theta);
            orientation.set(axisAngle);
            orientation.invert();
        }
        return orientation;
    }
}

