/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractStringToNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToDoubleConverter
extends AbstractStringToNumberConverter<Double> {
    private static final Logger Logger = LoggerFactory.getLogger(StringToDoubleConverter.class);

    public StringToDoubleConverter() {
        super(String.class, Double.class);
    }

    public StringToDoubleConverter(NumberFormat numberFormat) {
        super(String.class, Double.class);
        this.setNumberFormat(numberFormat);
    }

    public Double convert(String fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Double(this.getNumberFormat().parse(fromObject).doubleValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Double(fromObject);
    }
}

