/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractStringToNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToShortConverter
extends AbstractStringToNumberConverter<Short> {
    private static final Logger Logger = LoggerFactory.getLogger(StringToShortConverter.class);

    public StringToShortConverter() {
        super(String.class, Short.class);
    }

    public StringToShortConverter(NumberFormat numberFormat) {
        super(String.class, Short.class);
        this.setNumberFormat(numberFormat);
    }

    public Short convert(String fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Short(this.getNumberFormat().parse(fromObject).shortValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Short(fromObject);
    }
}

