/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ApogyCorePreferences;
import org.eclipse.apogy.common.emf.ApogyPreferences;
import org.eclipse.apogy.common.emf.ApogyPreferencesSet;
import org.eclipse.apogy.common.emf.ApogyUIPreferences;
import org.eclipse.apogy.common.emf.impl.ApogyPreferencesManagerImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyPreferencesManagerCustomImpl
extends ApogyPreferencesManagerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyPreferencesManagerCustomImpl.class);
    private boolean initialised = false;

    @Override
    public synchronized ApogyPreferencesSet getApogyPreferencesSet() {
        ApogyPreferencesSet tmp = super.getApogyPreferencesSet();
        if (!this.initialised) {
            this.intialise();
        }
        return tmp;
    }

    @Override
    public synchronized ApogyPreferences getPreferences(EClass eClass) {
        ApogyPreferences prefs = null;
        Iterator coreIt = this.getApogyPreferencesSet().getCorePreferences().iterator();
        while (coreIt.hasNext() && prefs == null) {
            ApogyCorePreferences root = (ApogyCorePreferences)coreIt.next();
            prefs = this.search(root, eClass);
        }
        Iterator uiIt = this.getApogyPreferencesSet().getUiPreferences().iterator();
        while (uiIt.hasNext() && prefs == null) {
            ApogyUIPreferences root = (ApogyUIPreferences)uiIt.next();
            prefs = this.search(root, eClass);
        }
        if (prefs == null) {
            prefs = this.createPreferences(eClass);
        }
        return prefs;
    }

    @Override
    public void load() throws Exception {
        URI uri = this.getStorageLocation();
        Logger.debug("Loading Preferences from <" + uri.toFileString() + ">...");
        TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
        domain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = domain.getResourceSet().getResource(uri, true);
        ApogyPreferencesSet apogyPreferencesSet = (ApogyPreferencesSet)resource.getContents().get(0);
        ApogyCommonTransactionFacade.INSTANCE.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.APOGY_PREFERENCES_MANAGER__APOGY_PREFERENCES_SET, apogyPreferencesSet, true);
    }

    @Override
    public void save() throws Exception {
        URI uri = this.getStorageLocation();
        Logger.debug("Saving Preferences to <" + uri.toFileString() + ">...");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)EcoreUtil.copy((EObject)this.getApogyPreferencesSet()));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }

    private URI getStorageLocation() {
        String path = String.valueOf(System.getProperty("user.home")) + File.separatorChar + "ApogyPreferences.xml";
        URI uri = URI.createFileURI((String)path);
        return uri;
    }

    private ApogyPreferences search(ApogyPreferences root, EClass eClass) {
        ApogyPreferences result = null;
        if (root.eClass() == eClass) {
            result = root;
        }
        Iterator it = root.getChildren().iterator();
        while (it.hasNext() && result == null) {
            ApogyPreferences prefs = (ApogyPreferences)it.next();
            result = prefs.eClass() == eClass ? prefs : this.search(prefs, eClass);
        }
        return result;
    }

    private synchronized ApogyPreferences createPreferences(EClass eClass) {
        ApogyPreferences prefs = null;
        if (eClass != null) {
            prefs = (ApogyPreferences)EcoreUtil.create((EClass)eClass);
            EClass parentClass = prefs.getParentEClass();
            if (parentClass != null) {
                ApogyPreferences parentPreferences = this.getPreferences(parentClass);
                if (parentPreferences != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)parentPreferences, (EStructuralFeature)ApogyCommonEMFPackage.Literals.APOGY_PREFERENCES__CHILDREN, prefs, true);
                }
            } else if (prefs != null && prefs.getParent() == null) {
                if (prefs instanceof ApogyCorePreferences) {
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.getApogyPreferencesSet(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.APOGY_PREFERENCES_SET__CORE_PREFERENCES, prefs, true);
                } else if (prefs instanceof ApogyUIPreferences) {
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this.getApogyPreferencesSet(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.APOGY_PREFERENCES_SET__UI_PREFERENCES, prefs, true);
                }
            }
        } else {
            Logger.warn("createPreferences() was passed a null eClass");
        }
        return prefs;
    }

    private synchronized void intialise() {
        this.initialised = true;
        List<EClass> apogyPreferences = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(ApogyCommonEMFPackage.Literals.APOGY_PREFERENCES);
        for (EClass preferenceEClass : apogyPreferences) {
            try {
                if (preferenceEClass.isAbstract()) continue;
                Logger.info("Creating preference of type <" + preferenceEClass.getName() + ">...");
                this.getPreferences(preferenceEClass);
            }
            catch (Exception e) {
                Logger.error("Failed to create preference of type <" + preferenceEClass.getName() + "> !");
                e.printStackTrace();
            }
        }
    }
}

