/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.impl.CurrentTimeSourceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTimeSourceCustomImpl
extends CurrentTimeSourceImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CurrentTimeSourceImpl.class);
    private boolean disposed = false;
    private Job updateJob = null;

    @Override
    public void pause() {
        Logger.debug("Pausing");
        this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.CURRENT_TIME_SOURCE__PAUSED, true);
    }

    @Override
    public void resume() {
        Logger.debug("Resuming.");
        Date now = new Date();
        this.updateTime(now);
        this.getUpdateJob();
        this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.CURRENT_TIME_SOURCE__PAUSED, false);
    }

    @Override
    public void dispose() {
        Logger.debug("Disposing...");
        this.disposed = true;
        if (this.updateJob != null) {
            this.getUpdateJob().cancel();
            this.setUpdateJob(null);
        }
    }

    protected void setUpdateJob(Job updateJob) {
        this.updateJob = updateJob;
    }

    protected Job getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = new Job("CurrentTimeSource update"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled() && !CurrentTimeSourceCustomImpl.this.disposed) {
                        try {
                            if (!CurrentTimeSourceCustomImpl.this.isPaused()) {
                                Date now = new Date();
                                CurrentTimeSourceCustomImpl.this.updateTime(now);
                            }
                            CurrentTimeSourceCustomImpl.this.updateJob.schedule((long)CurrentTimeSourceCustomImpl.this.getUpdatePeriod());
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.updateJob.schedule();
        }
        return this.updateJob;
    }
}

