/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.impl.FeatureNodeAdapterImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FeatureNodeAdapterCustomImpl
extends FeatureNodeAdapterImpl {
    private Adapter adapter = null;
    private final List<EObject> eObjects = new ArrayList<EObject>();
    private List<EStructuralFeature> featuresOfInterest = null;

    @Override
    public void setSourceObject(EObject newSourceObject) {
        this.setCurrentValue(null);
        this.setResolved(false);
        this.getFeaturesOfInterest().clear();
        this.unregisterAdapter(this.getSourceObject(), this.getFeatureNode());
        super.setSourceObject(newSourceObject);
        if (newSourceObject != null && this.getFeatureNode() != null) {
            boolean newResolved = ApogyCommonEMFFacade.INSTANCE.isResolved(newSourceObject, this.getFeatureNode());
            this.setResolved(newResolved);
            if (newResolved) {
                this.setCurrentValue(ApogyCommonEMFFacade.INSTANCE.resolve(newSourceObject, this.getFeatureNode()));
            }
        }
        this.registerAdapter(this.getSourceObject(), this.getFeatureNode());
    }

    @Override
    public void setFeatureNode(AbstractFeatureNode newFeatureNode) {
        this.setCurrentValue(null);
        this.setResolved(false);
        this.getFeaturesOfInterest().clear();
        this.unregisterAdapter(this.getSourceObject(), newFeatureNode);
        super.setFeatureNode(newFeatureNode);
        if (newFeatureNode != null) {
            this.initializeFeatureOfInterest(newFeatureNode);
        }
        if (this.getSourceObject() != null && newFeatureNode != null) {
            boolean newResolved = ApogyCommonEMFFacade.INSTANCE.isResolved(this.getSourceObject(), newFeatureNode);
            this.setResolved(newResolved);
            if (newResolved) {
                this.setCurrentValue(ApogyCommonEMFFacade.INSTANCE.resolve(this.getSourceObject(), newFeatureNode));
            }
        }
        this.registerAdapter(this.getSourceObject(), this.getFeatureNode());
    }

    protected void unregisterAdapter(EObject source, AbstractFeatureNode node) {
        for (EObject eObject : this.eObjects) {
            eObject.eAdapters().remove((Object)this.getAdapter());
        }
        this.eObjects.clear();
    }

    protected void registerAdapter(EObject source, AbstractFeatureNode node) {
        if (source != null && node != null) {
            source.eAdapters().add((Object)this.getAdapter());
            this.eObjects.add(source);
            List<AbstractFeatureNode> nodes = ApogyCommonEMFFacade.INSTANCE.getAncestries(node);
            Iterator<AbstractFeatureNode> it = nodes.iterator();
            EObject eObject = source;
            while (it.hasNext()) {
                BasicEList list;
                AbstractFeatureNode abstractFeatureNode = it.next();
                if (!(abstractFeatureNode instanceof AbstractFeatureSpecifier)) continue;
                AbstractFeatureSpecifier featureSpecifier = (AbstractFeatureSpecifier)((Object)abstractFeatureNode);
                Object object = null;
                object = featureSpecifier.isMultiValued() ? ((list = (BasicEList)eObject.eGet(featureSpecifier.getStructuralFeature())) != null && featureSpecifier.getIndex() >= 0 && featureSpecifier.getIndex() < list.size() ? list.get(featureSpecifier.getIndex()) : null) : eObject.eGet(featureSpecifier.getStructuralFeature());
                if (!(object instanceof EObject)) continue;
                eObject = (EObject)object;
                eObject.eAdapters().add((Object)this.getAdapter());
                this.eObjects.add(eObject);
            }
        }
    }

    protected void initializeFeatureOfInterest(AbstractFeatureNode featureNode) {
        List<AbstractFeatureNode> nodes = ApogyCommonEMFFacade.INSTANCE.getAncestries(featureNode);
        for (AbstractFeatureNode node : nodes) {
            AbstractFeatureSpecifier featureSpecifier;
            if (!(node instanceof AbstractFeatureSpecifier) || (featureSpecifier = (AbstractFeatureSpecifier)((Object)node)).getStructuralFeature() == null) continue;
            this.getFeaturesOfInterest().add(featureSpecifier.getStructuralFeature());
        }
    }

    protected List<EStructuralFeature> getFeaturesOfInterest() {
        if (this.featuresOfInterest == null) {
            this.featuresOfInterest = new ArrayList<EStructuralFeature>();
        }
        return this.featuresOfInterest;
    }

    protected boolean isFeatureInAncestries(EStructuralFeature eStructuralFeature) {
        return this.getFeaturesOfInterest().contains(eStructuralFeature);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getEventType() != 8 && notification.getNotifier() instanceof EObject) {
                        EStructuralFeature eStructuralFeature;
                        EStructuralFeature structuralFeature = null;
                        if (FeatureNodeAdapterCustomImpl.this.getFeatureNode() instanceof AbstractFeatureSpecifier) {
                            structuralFeature = ((AbstractFeatureSpecifier)((Object)FeatureNodeAdapterCustomImpl.this.getFeatureNode())).getStructuralFeature();
                        }
                        if (notification.getFeature() == structuralFeature) {
                            FeatureNodeAdapterCustomImpl.this.setCurrentValue(notification.getNewValue());
                        } else if (notification.getFeature() instanceof EStructuralFeature && FeatureNodeAdapterCustomImpl.this.isFeatureInAncestries(eStructuralFeature = (EStructuralFeature)notification.getFeature())) {
                            FeatureNodeAdapterCustomImpl.this.unregisterAdapter(FeatureNodeAdapterCustomImpl.this.getSourceObject(), FeatureNodeAdapterCustomImpl.this.getFeatureNode());
                            FeatureNodeAdapterCustomImpl.this.registerAdapter(FeatureNodeAdapterCustomImpl.this.getSourceObject(), FeatureNodeAdapterCustomImpl.this.getFeatureNode());
                            if (FeatureNodeAdapterCustomImpl.this.getSourceObject() != null && FeatureNodeAdapterCustomImpl.this.getFeatureNode() != null) {
                                FeatureNodeAdapterCustomImpl.this.setResolved(ApogyCommonEMFFacade.INSTANCE.isResolved(FeatureNodeAdapterCustomImpl.this.getSourceObject(), FeatureNodeAdapterCustomImpl.this.getFeatureNode()));
                                FeatureNodeAdapterCustomImpl.this.setCurrentValue(ApogyCommonEMFFacade.INSTANCE.resolve(FeatureNodeAdapterCustomImpl.this.getSourceObject(), FeatureNodeAdapterCustomImpl.this.getFeatureNode()));
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

