/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.CoordinatesSet;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesMesh;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSetExtent;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.SphericalCoordinates;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;

public class Geometry3DUtilities {
    public static CartesianAxis getPerpendicularAxis(CartesianPlane plane) {
        CartesianAxis axis = null;
        switch (plane.getValue()) {
            case 0: {
                axis = CartesianAxis.Z;
                break;
            }
            case 1: {
                axis = CartesianAxis.Y;
                break;
            }
            case 2: {
                axis = CartesianAxis.X;
            }
        }
        return axis;
    }

    public static CartesianPlane getPerpendicularPlane(CartesianAxis axis) {
        CartesianPlane plane = null;
        switch (axis.getValue()) {
            case 0: {
                plane = CartesianPlane.YZ;
                break;
            }
            case 1: {
                plane = CartesianPlane.XZ;
                break;
            }
            case 2: {
                plane = CartesianPlane.XY;
            }
        }
        return plane;
    }

    public static SphericalCoordinates getSphericalCoordinates(CartesianPositionCoordinates cartesianCoordinates) {
        double x2y2 = cartesianCoordinates.getX() * cartesianCoordinates.getX() + cartesianCoordinates.getY() * cartesianCoordinates.getY();
        double r = Math.sqrt(x2y2 + cartesianCoordinates.getZ() * cartesianCoordinates.getZ());
        double phi = 0.0;
        phi = r != 0.0 ? Math.acos(cartesianCoordinates.getZ() / r) : Math.toRadians(90.0);
        double theta = Math.atan2(cartesianCoordinates.getY(), cartesianCoordinates.getX());
        return ApogyCommonGeometryData3DFacade.INSTANCE.createSphericalCoordinates(phi, theta, r);
    }

    public static CartesianPositionCoordinates getCartesianPositionCoordinates(SphericalCoordinates sphericalCoordinates) {
        double x = sphericalCoordinates.getR() * Math.sin(sphericalCoordinates.getPhi()) * Math.cos(sphericalCoordinates.getTheta());
        double y = sphericalCoordinates.getR() * Math.sin(sphericalCoordinates.getPhi()) * Math.sin(sphericalCoordinates.getTheta());
        double z = sphericalCoordinates.getR() * Math.cos(sphericalCoordinates.getPhi());
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
    }

    public static CartesianPositionCoordinates getCentroid(List<CartesianPositionCoordinates> coordinates) {
        return Geometry3DUtilities.getCentroid(coordinates, null);
    }

    public static Point3d getFlattenCoordinate(CartesianPlane plane, Point3d point) {
        Point3d flattenPoint = null;
        switch (plane.getValue()) {
            case 0: {
                flattenPoint = new Point3d(point.x, point.y, 0.0);
                break;
            }
            case 1: {
                flattenPoint = new Point3d(point.x, 0.0, point.z);
                break;
            }
            case 2: {
                flattenPoint = new Point3d(0.0, point.y, point.z);
            }
        }
        return flattenPoint;
    }

    public static CartesianPositionCoordinates getFlattenCoordinate(CartesianPlane plane, CartesianPositionCoordinates point) {
        Point3d flattenPoint = Geometry3DUtilities.getFlattenCoordinate(plane, point.asPoint3d());
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(flattenPoint.x, flattenPoint.y, flattenPoint.z);
    }

    public static List<Point3d> getPoint3dFlattenCoordinates(CartesianPlane plane, List<Point3d> coordinates) {
        ArrayList<Point3d> flattenCoordinates = new ArrayList<Point3d>();
        for (Point3d p : coordinates) {
            Point3d flattenP = Geometry3DUtilities.getFlattenCoordinate(plane, p);
            flattenCoordinates.add(flattenP);
        }
        return flattenCoordinates;
    }

    public static List<CartesianPositionCoordinates> getFlattenCoordinates(CartesianPlane plane, List<CartesianPositionCoordinates> coordinates) {
        ArrayList<CartesianPositionCoordinates> flattenCoordinates = new ArrayList<CartesianPositionCoordinates>();
        for (CartesianPositionCoordinates p : coordinates) {
            CartesianPositionCoordinates flattenP = Geometry3DUtilities.getFlattenCoordinate(plane, p);
            flattenCoordinates.add(flattenP);
        }
        return flattenCoordinates;
    }

    public static CartesianPositionCoordinates getCentroid(List<CartesianPositionCoordinates> coordinates, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            internalMonitor.beginTask(String.valueOf(Geometry3DUtilities.class.getSimpleName()) + ".getCentroid", coordinates.size());
            for (CartesianPositionCoordinates coord : coordinates) {
                if (coord != null) {
                    x += coord.getX();
                    y += coord.getY();
                    z += coord.getZ();
                }
                internalMonitor.worked(1);
            }
            if (coordinates.size() > 0) {
                x /= (double)coordinates.size();
                y /= (double)coordinates.size();
                z /= (double)coordinates.size();
            }
        }
        finally {
            internalMonitor.done();
        }
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
    }

    public static double getPolygonSurface(List<CartesianPositionCoordinates> vertices) {
        double area = 0.0;
        if (vertices.size() == 3) {
            CartesianPositionCoordinates p1 = vertices.get(0);
            CartesianPositionCoordinates p2 = vertices.get(1);
            CartesianPositionCoordinates p3 = vertices.get(2);
            Vector3d u = new Vector3d(p2.getX() - p1.getX(), p2.getY() - p1.getY(), p2.getZ() - p1.getZ());
            Vector3d v = new Vector3d(p3.getX() - p1.getX(), p3.getY() - p1.getY(), p3.getZ() - p1.getZ());
            Vector3d normal = new Vector3d();
            normal.cross(u, v);
            area += normal.length() / 2.0;
        } else if (vertices.size() > 3) {
            throw new UnsupportedOperationException("getPolygonSurface() for polygons with more that 3 vertices is not implemented yet.");
        }
        return area;
    }

    public static Vector3d getPolygonNormal(List<CartesianPositionCoordinates> vertices) {
        Vector3d normal = null;
        if (vertices.size() == 3) {
            CartesianPositionCoordinates p1 = vertices.get(0);
            CartesianPositionCoordinates p2 = vertices.get(1);
            CartesianPositionCoordinates p3 = vertices.get(2);
            Vector3d u = new Vector3d(p2.getX() - p1.getX(), p2.getY() - p1.getY(), p2.getZ() - p1.getZ());
            Vector3d v = new Vector3d(p3.getX() - p1.getX(), p3.getY() - p1.getY(), p3.getZ() - p1.getZ());
            normal = new Vector3d();
            normal.cross(u, v);
        } else if (vertices.size() > 3) {
            throw new UnsupportedOperationException("getPolygonNormal() for polygons with more that 3 vertices is not implemented yet.");
        }
        normal.normalize();
        return normal;
    }

    public static CartesianPositionCoordinates getProjectionInPolygonPlane(CartesianPositionCoordinates point, CartesianPolygon polygon) {
        if (polygon.getVertices().size() == 3) {
            Vector3d N = Geometry3DUtilities.getPolygonNormal((List<CartesianPositionCoordinates>)polygon.getVertices());
            N.normalize();
            Vector3d Q = new Vector3d(point.getX(), point.getY(), point.getZ());
            Vector3d P = new Vector3d(((CartesianPositionCoordinates)polygon.getVertices().get(0)).getX(), ((CartesianPositionCoordinates)polygon.getVertices().get(0)).getY(), ((CartesianPositionCoordinates)polygon.getVertices().get(0)).getZ());
            Vector3d PQ = new Vector3d();
            PQ.sub((Tuple3d)Q, (Tuple3d)P);
            double r = N.dot(PQ);
            Vector3d Qprime = new Vector3d(Q);
            N.scale(r);
            Qprime.sub((Tuple3d)Q, (Tuple3d)N);
            CartesianPositionCoordinates projection = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(Qprime.x, Qprime.y, Qprime.z);
            return projection;
        }
        if (polygon.getVertices().size() > 3) {
            throw new UnsupportedOperationException("getProjection() for polygons with more that 3 vertices is not implemented yet.");
        }
        return null;
    }

    public static CartesianPositionCoordinates getProjectionOnPolygon(CartesianPositionCoordinates point, CartesianPolygon polygon) {
        if (polygon.getVertices().size() == 3) {
            CartesianPositionCoordinates projection = Geometry3DUtilities.getProjectionInPolygonPlane(point, polygon);
            if (Geometry3DUtilities.isInsidePolygon(projection, polygon)) {
                return projection;
            }
            return null;
        }
        if (polygon.getVertices().size() > 3) {
            throw new UnsupportedOperationException("getProjection() for polygons with more that 3 vertices is not implemented yet.");
        }
        return null;
    }

    public static CartesianPositionCoordinates getProjectionAlongAxisOnToPolygon(CartesianAxis axis, Point3d point, CartesianPolygon polygon) {
        if (polygon.getVertices().size() == 3) {
            Point3d lineOrigin = null;
            Vector3d lineDirection = null;
            switch (axis.getValue()) {
                case 0: {
                    lineOrigin = new Point3d((double)1.4E-45f, point.getY(), point.getZ());
                    lineDirection = new Vector3d(1.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    lineOrigin = new Point3d(point.getX(), (double)1.4E-45f, point.getZ());
                    lineDirection = new Vector3d(0.0, 1.0, 0.0);
                    break;
                }
                case 2: {
                    lineOrigin = new Point3d(point.getX(), point.getY(), (double)1.4E-45f);
                    lineDirection = new Vector3d(0.0, 0.0, 1.0);
                }
            }
            Vector3d n = polygon.getNormal();
            n.normalize();
            double a = n.x;
            double b = n.y;
            double c = n.z;
            Vector3d vertex = new Vector3d((Tuple3d)((CartesianPositionCoordinates)polygon.getVertices().get(0)).asPoint3d());
            double d = -n.dot(vertex);
            double denominator = lineDirection.dot(n);
            if (Math.abs(denominator) == 0.0) {
                return null;
            }
            double t = -(a * lineOrigin.x + b * lineOrigin.y + c * lineOrigin.z + d);
            lineDirection.scale(t /= denominator);
            lineOrigin.add((Tuple3d)lineDirection);
            Point3d flattenedPoint = Geometry3DUtilities.getFlattenCoordinate(Geometry3DUtilities.getPerpendicularPlane(axis), point);
            List<CartesianPositionCoordinates> flattenedVertices = Geometry3DUtilities.getFlattenCoordinates(Geometry3DUtilities.getPerpendicularPlane(axis), (List<CartesianPositionCoordinates>)polygon.getVertices());
            CartesianPolygon flattenPolygon = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPolygon();
            flattenPolygon.getVertices().addAll(flattenedVertices);
            if (Geometry3DUtilities.isInsidePolygon(flattenedPoint, flattenPolygon)) {
                return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(lineOrigin.x, lineOrigin.y, lineOrigin.z);
            }
            return null;
        }
        if (polygon.getVertices().size() > 3) {
            throw new UnsupportedOperationException("getProjection() for polygons with more that 3 vertices is not implemented yet.");
        }
        return null;
    }

    public static CartesianPositionCoordinates getProjectionAlongAxisOnToPolygon(CartesianAxis axis, CartesianPositionCoordinates point, CartesianPolygon polygon) {
        if (polygon.getVertices().size() == 3) {
            Point3d lineOrigin = null;
            Vector3d lineDirection = null;
            switch (axis.getValue()) {
                case 0: {
                    lineOrigin = new Point3d((double)1.4E-45f, point.getY(), point.getZ());
                    lineDirection = new Vector3d(1.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    lineOrigin = new Point3d(point.getX(), (double)1.4E-45f, point.getZ());
                    lineDirection = new Vector3d(0.0, 1.0, 0.0);
                    break;
                }
                case 2: {
                    lineOrigin = new Point3d(point.getX(), point.getY(), (double)1.4E-45f);
                    lineDirection = new Vector3d(0.0, 0.0, 1.0);
                }
            }
            Vector3d n = polygon.getNormal();
            n.normalize();
            double a = n.x;
            double b = n.y;
            double c = n.z;
            Vector3d vertex = new Vector3d((Tuple3d)((CartesianPositionCoordinates)polygon.getVertices().get(0)).asPoint3d());
            double d = -n.dot(vertex);
            double denominator = lineDirection.dot(n);
            if (Math.abs(denominator) == 0.0) {
                return null;
            }
            double t = -(a * lineOrigin.x + b * lineOrigin.y + c * lineOrigin.z + d);
            lineDirection.scale(t /= denominator);
            lineOrigin.add((Tuple3d)lineDirection);
            CartesianPositionCoordinates flattenedPoint = Geometry3DUtilities.getFlattenCoordinate(Geometry3DUtilities.getPerpendicularPlane(axis), point);
            List<CartesianPositionCoordinates> flattenedVertices = Geometry3DUtilities.getFlattenCoordinates(Geometry3DUtilities.getPerpendicularPlane(axis), (List<CartesianPositionCoordinates>)polygon.getVertices());
            CartesianPolygon flattenPolygon = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPolygon();
            flattenPolygon.getVertices().addAll(flattenedVertices);
            if (Geometry3DUtilities.isInsidePolygon(flattenedPoint, flattenPolygon)) {
                return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(lineOrigin.x, lineOrigin.y, lineOrigin.z);
            }
            return null;
        }
        if (polygon.getVertices().size() > 3) {
            throw new UnsupportedOperationException("getProjection() for polygons with more that 3 vertices is not implemented yet.");
        }
        return null;
    }

    public static <T extends CartesianPolygon> CartesianPositionCoordinates[] getProjectionAlongAxisOnToPolygon(CartesianAxis axis, List<CartesianPositionCoordinates> points, List<T> polygons) {
        CartesianPositionCoordinates centroid = Geometry3DUtilities.getCentroid(points);
        SortedSet<CartesianPolygon> sortedPolygons = Geometry3DUtilities.sortCartesianPolygonByDistance(centroid, polygons);
        CartesianPositionCoordinates[] intersections = new CartesianPositionCoordinates[points.size()];
        int i = 0;
        while (i < points.size()) {
            CartesianPositionCoordinates point = points.get(i);
            CartesianPositionCoordinates projection = null;
            Iterator it = sortedPolygons.iterator();
            while (projection == null && it.hasNext()) {
                CartesianPolygon polygon = (CartesianPolygon)it.next();
                projection = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon(CartesianAxis.Z, point, polygon);
            }
            intersections[i] = projection;
            ++i;
        }
        return intersections;
    }

    public static CartesianCoordinatesMesh getProjectedCartesianCoordinatesMeshOnPlane(CartesianCoordinatesMesh mesh, CartesianPolygon projectionPlanePolygon) {
        CartesianCoordinatesMesh newMesh = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianCoordinatesMesh(mesh);
        for (CartesianPositionCoordinates vMesh : newMesh.getPoints()) {
            CartesianPositionCoordinates vProj = Geometry3DUtilities.getProjectionInPolygonPlane(vMesh, projectionPlanePolygon);
            vMesh.setX(vProj.getX());
            vMesh.setY(vProj.getY());
            vMesh.setZ(vProj.getZ());
        }
        return newMesh;
    }

    public static CartesianTriangularMesh getProjectedCartesianTriangularMeshOnPlane(CartesianTriangularMesh mesh, CartesianPolygon projectionPlanePolygon) {
        CartesianTriangularMesh newMesh = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangularMesh((List<CartesianTriangle>)mesh.getPolygons());
        for (CartesianPositionCoordinates vMesh : newMesh.getPoints()) {
            CartesianPositionCoordinates vProj = Geometry3DUtilities.getProjectionInPolygonPlane(vMesh, projectionPlanePolygon);
            vMesh.setX(vProj.getX());
            vMesh.setY(vProj.getY());
            vMesh.setZ(vProj.getZ());
        }
        return newMesh;
    }

    public static boolean isInsidePolygon(Point3d point, CartesianPolygon polygon) {
        boolean isInside = true;
        Object[] vertices = new CartesianPositionCoordinates[polygon.getVertices().size() + 1];
        polygon.getVertices().toArray(vertices);
        int i = 0;
        int vertexCount = vertices.length - 1;
        vertices[vertexCount] = vertices[0];
        Vector3d polygonNormal = Geometry3DUtilities.getPolygonNormal((List<CartesianPositionCoordinates>)polygon.getVertices());
        Point3d c = new Point3d(point.x, point.y, point.z);
        while (i < vertexCount && isInside) {
            Point3d b;
            Point3d a = new Point3d(vertices[i].getX(), vertices[i].getY(), vertices[i].getZ());
            if (Geometry3DUtilities.getSide(a, b = new Point3d(vertices[i + 1].getX(), vertices[i + 1].getY(), vertices[i + 1].getZ()), c, polygonNormal) < 0) {
                isInside = false;
            }
            ++i;
        }
        return isInside;
    }

    public static boolean isInsidePolygon(CartesianPositionCoordinates point, CartesianPolygon polygon) {
        return Geometry3DUtilities.isInsidePolygon(point.asPoint3d(), polygon);
    }

    public static <T extends CartesianPolygon> boolean isSphereIntersectsPolygon(CartesianPositionCoordinates center, double radius, boolean includeZeroOverlap, T polygon) {
        boolean isInside = false;
        if (Geometry3DUtilities.isInsidePolygon(center, polygon)) {
            isInside = true;
        }
        if (!isInside) {
            int i = 0;
            while (i < polygon.getVertices().size() && !isInside) {
                CartesianPositionCoordinates point = (CartesianPositionCoordinates)polygon.getVertices().get(i);
                Vector3d tmp = new Vector3d();
                tmp.sub((Tuple3d)point.asPoint3d(), (Tuple3d)center.asPoint3d());
                double length = tmp.length();
                if (length <= radius) {
                    if (includeZeroOverlap) {
                        isInside = true;
                    } else if (length < radius) {
                        isInside = true;
                    }
                }
                ++i;
            }
        }
        if (!isInside) {
            Object[] vertices = new CartesianPositionCoordinates[polygon.getVertices().size() + 1];
            polygon.getVertices().toArray(vertices);
            int i = 0;
            int vertexCount = vertices.length - 1;
            vertices[vertexCount] = vertices[0];
            Vector3d c = new Vector3d(center.getX(), center.getY(), center.getZ());
            while (i < vertexCount && !isInside) {
                Vector3d b;
                Vector3d a = new Vector3d(vertices[i].getX(), vertices[i].getY(), vertices[i].getZ());
                Vector3d centerProjectionOnEdge = Geometry3DUtilities.getProjectionOfPointOntoLineSegment(c, a, b = new Vector3d(vertices[i + 1].getX(), vertices[i + 1].getY(), vertices[i + 1].getZ()));
                if (centerProjectionOnEdge != null) {
                    Vector3d tmp = new Vector3d(c);
                    tmp.sub((Tuple3d)centerProjectionOnEdge);
                    if (tmp.length() <= radius) {
                        if (includeZeroOverlap) {
                            isInside = true;
                        } else if (tmp.length() < radius) {
                            isInside = true;
                        }
                    }
                }
                ++i;
            }
        }
        return isInside;
    }

    public static double getPointToLineDistance(CartesianPositionCoordinates point, CartesianPositionCoordinates p1, CartesianPositionCoordinates p2) {
        return Geometry3DUtilities.getPointToLineDistance(new Vector3d((Tuple3d)point.asPoint3d()), new Vector3d((Tuple3d)p1.asPoint3d()), new Vector3d((Tuple3d)p2.asPoint3d()));
    }

    public static double getPointToLineDistance(Vector3d point, Vector3d p1, Vector3d p2) {
        Vector3d projectionOntoLine = Geometry3DUtilities.getProjectionOfPointOntoLine(point, p1, p2);
        projectionOntoLine.sub((Tuple3d)point);
        return projectionOntoLine.length();
    }

    public static CartesianPositionCoordinates getProjectionOfPointOntoLine(CartesianPositionCoordinates point, CartesianPositionCoordinates p1, CartesianPositionCoordinates p2) {
        Vector3d q = Geometry3DUtilities.getProjectionOfPointOntoLine(new Vector3d((Tuple3d)point.asPoint3d()), new Vector3d((Tuple3d)p1.asPoint3d()), new Vector3d((Tuple3d)p2.asPoint3d()));
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(q.x, q.y, q.z);
    }

    public static Vector3d getProjectionOfPointOntoLine(Vector3d point, Vector3d p1, Vector3d p2) {
        Vector3d direction = new Vector3d();
        direction.sub((Tuple3d)p2, (Tuple3d)p1);
        Vector3d qp = new Vector3d();
        qp.sub((Tuple3d)point, (Tuple3d)p1);
        double t = direction.dot(qp);
        Vector3d qPrime = new Vector3d();
        direction.scale(t);
        qPrime.add((Tuple3d)p1, (Tuple3d)direction);
        return qPrime;
    }

    public static CartesianPositionCoordinates getProjectionOfPointOntoLineSegment(CartesianPositionCoordinates point, CartesianPositionCoordinates p1, CartesianPositionCoordinates p2) {
        Vector3d q = Geometry3DUtilities.getProjectionOfPointOntoLine(new Vector3d((Tuple3d)point.asPoint3d()), new Vector3d((Tuple3d)p1.asPoint3d()), new Vector3d((Tuple3d)p2.asPoint3d()));
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(q.x, q.y, q.z);
    }

    public static Vector3d getProjectionOfPointOntoLineSegment(Vector3d point, Vector3d p1, Vector3d p2) {
        Vector3d direction = new Vector3d();
        direction.sub((Tuple3d)p2, (Tuple3d)p1);
        Vector3d qp = new Vector3d();
        qp.sub((Tuple3d)point, (Tuple3d)p1);
        double t = direction.dot(qp);
        if (0.0 <= t && t <= 1.0) {
            Vector3d qPrime = new Vector3d();
            direction.scale(t);
            qPrime.add((Tuple3d)p1, (Tuple3d)direction);
            return qPrime;
        }
        return null;
    }

    public static <T extends CartesianPolygon> boolean isLineIntersectsAllPolygons(CartesianPlane plane, CartesianPositionCoordinates p1, CartesianPositionCoordinates p2, List<T> polygons) {
        boolean intersect = true;
        int i = 0;
        while (intersect && i < polygons.size()) {
            CartesianPolygon polygon = (CartesianPolygon)polygons.get(i);
            if (!Geometry3DUtilities.isLineIntersectsPolygon(plane, p1, p2, polygon)) {
                intersect = false;
            }
            ++i;
        }
        return intersect;
    }

    public static <T extends CartesianPolygon> boolean isLineIntersectsPolygon(CartesianPlane plane, CartesianPositionCoordinates p1, CartesianPositionCoordinates p2, T polygon) {
        if (polygon.getVertices().size() > 2) {
            Vector2d u1 = Geometry3DUtilities.getVector2D(plane, p1);
            Vector2d u2 = Geometry3DUtilities.getVector2D(plane, p2);
            int i = 0;
            while (i < polygon.getVertices().size()) {
                CartesianPositionCoordinates e1 = null;
                CartesianPositionCoordinates e2 = null;
                if (i < polygon.getVertices().size() - 1) {
                    e1 = (CartesianPositionCoordinates)polygon.getVertices().get(i);
                    e2 = (CartesianPositionCoordinates)polygon.getVertices().get(i + 1);
                } else {
                    e1 = (CartesianPositionCoordinates)polygon.getVertices().get(polygon.getVertices().size() - 1);
                    e2 = (CartesianPositionCoordinates)polygon.getVertices().get(0);
                }
                Vector2d v1 = Geometry3DUtilities.getVector2D(plane, e1);
                Vector2d v2 = Geometry3DUtilities.getVector2D(plane, e2);
                Vector2d intersect = Geometry3DUtilities.getLineIntersectionPoint(u1, u2, v1, v2);
                if (intersect != null) {
                    double edgeLength = Geometry3DUtilities.getDistance(v1, v2);
                    double lineLength = Geometry3DUtilities.getDistance(u1, u2);
                    if (Geometry3DUtilities.getDistance(intersect, v1) < edgeLength && Geometry3DUtilities.getDistance(intersect, v1) > 0.0 && Geometry3DUtilities.getDistance(intersect, v2) < edgeLength && Geometry3DUtilities.getDistance(intersect, v2) > 0.0 && Geometry3DUtilities.getDistance(intersect, u1) < lineLength && Geometry3DUtilities.getDistance(intersect, u1) > 0.0 && Geometry3DUtilities.getDistance(intersect, u2) < lineLength && Geometry3DUtilities.getDistance(intersect, u2) > 0.0) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static double getDistance(Vector2d v1, Vector2d v2) {
        return Math.sqrt((v1.x - v2.x) * (v1.x - v2.x) + (v1.y - v2.y) * (v1.y - v2.y));
    }

    public static Vector2d getVector2D(CartesianPlane plane, CartesianPositionCoordinates point) {
        Vector2d vector2d = null;
        switch (plane.getValue()) {
            case 0: {
                vector2d = new Vector2d(point.getX(), point.getY());
                break;
            }
            case 1: {
                vector2d = new Vector2d(point.getX(), point.getZ());
                break;
            }
            case 2: {
                vector2d = new Vector2d(point.getY(), point.getZ());
            }
        }
        return vector2d;
    }

    public static Point3d getLineAndPolygonIntersectionPoint(Vector3d u, Vector3d v, CartesianPolygon polygon) {
        Vector3d n = polygon.getNormal();
        n.normalize();
        Point3d p0 = ((CartesianPositionCoordinates)polygon.getVertices().get(0)).asPoint3d();
        Vector3d l0 = new Vector3d(u);
        Vector3d l = new Vector3d(v);
        l.sub((Tuple3d)u);
        Vector3d lDotn = new Vector3d(l);
        double numerator = lDotn.dot(n);
        Vector3d p0l0 = new Vector3d((Tuple3d)p0);
        p0l0.sub((Tuple3d)l0);
        double denominator = p0l0.dot(n);
        if (numerator == 0.0) {
            if (denominator == 0.0) {
                return new Point3d((Tuple3d)u);
            }
            return null;
        }
        double d = denominator / numerator;
        if (d >= 0.0 && d <= 1.0) {
            Vector3d line = new Vector3d(l);
            line.scale(d);
            line.add((Tuple3d)u);
            Point3d intersection = new Point3d((Tuple3d)line);
            CartesianPositionCoordinates p = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(intersection.x, intersection.y, intersection.z);
            if (Geometry3DUtilities.isInsidePolygon(p, polygon)) {
                return intersection;
            }
        }
        return null;
    }

    public static Vector2d getLineIntersectionPoint(Vector2d u1, Vector2d u2, Vector2d v1, Vector2d v2) {
        double d = (u1.x - u2.x) * (v1.y - v2.y) - (u1.y - u2.y) * (v1.x - v2.x);
        if (d == 0.0) {
            return null;
        }
        double xi = ((v1.x - v2.x) * (u1.x * u2.y - u1.y * u2.x) - (u1.x - u2.x) * (v1.x * v2.y - v1.y * v2.x)) / d;
        double yi = ((v1.y - v2.y) * (u1.x * u2.y - u1.y * u2.x) - (u1.y - u2.y) * (v1.x * v2.y - v1.y * v2.x)) / d;
        return new Vector2d(xi, yi);
    }

    private static int getSide(Point3d a, Point3d b, Point3d point, Vector3d polygonNormal) {
        int result = 0;
        Vector3d ab = new Vector3d();
        ab.sub((Tuple3d)b, (Tuple3d)a);
        Vector3d ac = new Vector3d();
        ac.sub((Tuple3d)point, (Tuple3d)a);
        Vector3d normal = new Vector3d();
        normal.cross(ab, ac);
        double angle = normal.angle(polygonNormal);
        if (angle == 0.0) {
            result = 0;
        } else if (angle < Math.toRadians(90.0)) {
            result = 1;
        } else if (angle > Math.toRadians(90.0)) {
            result = -1;
        }
        return result;
    }

    public static SortedSet<CartesianPositionCoordinates> sortCartesianPositionCoordinatesByDistance(CartesianPositionCoordinates centerPoint, List<CartesianPositionCoordinates> points) {
        TreeSet<CartesianPositionCoordinates> sortedPoints = new TreeSet<CartesianPositionCoordinates>(new CartesianPositionCoordinatesDistanceComparator(centerPoint));
        sortedPoints.addAll(points);
        return sortedPoints;
    }

    public static SortedSet<CartesianPolygon> sortCartesianPolygonByDistance(CartesianPositionCoordinates centerPoint, Collection<? extends CartesianPolygon> polygons) {
        TreeSet<CartesianPolygon> sortedPolygons = new TreeSet<CartesianPolygon>(new CartesianPolygonCoordinatesDistanceComparator(centerPoint));
        sortedPolygons.addAll(polygons);
        return sortedPolygons;
    }

    public static <T extends CartesianPolygon> Vector3d getAverageNormal(Collection<T> polygons) {
        Vector3d averageNormal = new Vector3d(0.0, 0.0, 0.0);
        for (CartesianPolygon polygon : polygons) {
            Vector3d polygonNormal = polygon.getNormal();
            double polygonArea = polygon.getSurface();
            averageNormal.set(averageNormal.x + polygonArea * polygonNormal.x, averageNormal.y + polygonArea * polygonNormal.y, averageNormal.z + polygonArea * polygonNormal.z);
        }
        return averageNormal;
    }

    public static <T extends CartesianPolygon> double getSurfaceRoughnessIndex(Collection<T> polygons, Vector3d averageNormal, T polygon, double radius) {
        Point3d centre = polygon.getCentroid().asPoint3d();
        double maxRoughnessIndex = 0.0;
        double roughnessIndex = 0.0;
        Vector3d toVertex = new Vector3d();
        for (CartesianPolygon currentPolygon : polygons) {
            Point3d currentVertex = currentPolygon.getCentroid().asPoint3d();
            if (!(currentVertex.distance(centre) <= radius)) continue;
            toVertex.set(currentVertex.x - centre.x, currentVertex.y - centre.y, currentVertex.z - centre.z);
            roughnessIndex = Math.abs(toVertex.dot(averageNormal));
            if (!(roughnessIndex > maxRoughnessIndex)) continue;
            maxRoughnessIndex = roughnessIndex;
        }
        return maxRoughnessIndex;
    }

    public static double getDistance(CartesianPositionCoordinates from, CartesianPositionCoordinates to) {
        Point3d p1 = new Point3d(from.getX(), from.getY(), from.getZ());
        Point3d p2 = new Point3d(to.getX(), to.getY(), to.getZ());
        return p1.distance(p2);
    }

    public static double getDistance(CartesianPositionCoordinates point, CartesianPositionCoordinates u1, CartesianPositionCoordinates u2) {
        CartesianPositionCoordinates projectedPoint = Geometry3DUtilities.getProjection(point, u1, u2);
        return Geometry3DUtilities.getDistance(projectedPoint, point);
    }

    public static CartesianPositionCoordinates getProjection(CartesianPositionCoordinates point, CartesianPositionCoordinates u1, CartesianPositionCoordinates u2) {
        Vector3d u1point = new Vector3d(point.getX() - u1.getX(), point.getY() - u1.getY(), point.getZ() - u1.getZ());
        Vector3d u1u2 = new Vector3d(u2.getX() - u1.getX(), u2.getY() - u1.getY(), u2.getZ() - u1.getZ());
        double scale = u1point.dot(u1u2) / u1u2.lengthSquared();
        Vector3d projOnu1u2 = new Vector3d(u1u2);
        projOnu1u2.scale(scale);
        Vector3d u1Vector = new Vector3d(u1.getX(), u1.getY(), u1.getZ());
        projOnu1u2.add((Tuple3d)u1Vector);
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(projOnu1u2.x, projOnu1u2.y, projOnu1u2.z);
    }

    public static CartesianPositionCoordinates getMaximumPosition(CartesianAxis axis, List<CartesianPositionCoordinates> points) {
        return Geometry3DUtilities.getMaximumPosition(axis, points, null);
    }

    public static CartesianPositionCoordinates getMaximumPosition(CartesianAxis axis, List<CartesianPositionCoordinates> points, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(0.0, 0.0, 0.0);
        double max = Double.NEGATIVE_INFINITY;
        try {
            internalMonitor.beginTask(String.valueOf(Geometry3DUtilities.class.getSimpleName()) + ".getMaximumPosition", points.size());
            for (CartesianPositionCoordinates p : points) {
                double value = 0.0;
                switch (axis.getValue()) {
                    case 0: {
                        value = p.getX();
                        break;
                    }
                    case 1: {
                        value = p.getY();
                        break;
                    }
                    case 2: {
                        value = p.getZ();
                    }
                }
                if (value > max) {
                    max = value;
                    coord = p;
                }
                internalMonitor.worked(1);
            }
        }
        finally {
            internalMonitor.done();
        }
        return coord;
    }

    public static CartesianPositionCoordinates getMinimumPosition(CartesianAxis axis, List<CartesianPositionCoordinates> points) {
        return Geometry3DUtilities.getMinimumPosition(axis, points, null);
    }

    public static CartesianPositionCoordinates getMinimumPosition(CartesianAxis axis, List<CartesianPositionCoordinates> points, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(0.0, 0.0, 0.0);
        double min = Double.POSITIVE_INFINITY;
        try {
            internalMonitor.beginTask(String.valueOf(Geometry3DUtilities.class.getSimpleName()) + ".getMinimumPosition", points.size());
            for (CartesianPositionCoordinates p : points) {
                double value = 0.0;
                switch (axis.getValue()) {
                    case 0: {
                        value = p.getX();
                        break;
                    }
                    case 1: {
                        value = p.getY();
                        break;
                    }
                    case 2: {
                        value = p.getZ();
                    }
                }
                if (value < min) {
                    min = value;
                    coord = p;
                }
                internalMonitor.worked(1);
            }
        }
        finally {
            internalMonitor.done();
        }
        return coord;
    }

    public static double getAngle(CartesianAxis axis, List<CartesianPositionCoordinates> vertices) {
        double slope = 0.0;
        if (vertices.size() > 2) {
            Vector3d axisVector = null;
            switch (axis.getValue()) {
                case 0: {
                    axisVector = new Vector3d(1.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    axisVector = new Vector3d(0.0, 1.0, 0.0);
                    break;
                }
                case 2: {
                    axisVector = new Vector3d(0.0, 0.0, 1.0);
                }
            }
            Vector3d normal = Geometry3DUtilities.getPolygonNormal(vertices);
            slope = normal.angle(axisVector);
            if (slope > 1.5707963267948966) {
                slope -= 1.5707963267948966;
            }
        }
        return slope;
    }

    public static double getAngle(CartesianPlane plane, CartesianPositionCoordinates v1, CartesianPositionCoordinates v2) {
        double angle = 0.0;
        if (Geometry3DUtilities.getDistance(v1, v2) != 0.0) {
            Vector3d axisVector = null;
            switch (plane.getValue()) {
                case 0: {
                    axisVector = new Vector3d(0.0, 0.0, 1.0);
                    break;
                }
                case 1: {
                    axisVector = new Vector3d(0.0, 1.0, 0.0);
                    break;
                }
                case 2: {
                    axisVector = new Vector3d(1.0, 0.0, 0.0);
                }
            }
            Vector3d v = new Vector3d(v2.getX() - v1.getX(), v2.getY() - v1.getY(), v2.getZ() - v1.getZ());
            angle = 1.5707963267948966 - v.angle(axisVector);
        }
        return angle;
    }

    public static List<CartesianPositionCoordinates> getCartesianCoordinatesWithinRadius(CartesianPositionCoordinates centerPoint, double radius, List<CartesianPositionCoordinates> points) {
        ArrayList<CartesianPositionCoordinates> pointsWithinRadius = new ArrayList<CartesianPositionCoordinates>();
        if (points.size() > 0) {
            SortedSet<CartesianPositionCoordinates> sortedPoints = Geometry3DUtilities.sortCartesianPositionCoordinatesByDistance(centerPoint, points);
            CartesianPositionCoordinates pointOnSurface = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(centerPoint.getX() + radius, centerPoint.getY(), centerPoint.getZ());
            pointsWithinRadius.addAll(sortedPoints.headSet(pointOnSurface));
            if (sortedPoints.contains(pointOnSurface)) {
                pointsWithinRadius.add(sortedPoints.tailSet(pointOnSurface).first());
            }
        }
        return pointsWithinRadius;
    }

    public static <T extends CartesianPolygon> Set<T> getCartesianPolygonsPartiallyWithinRadius(T centerPolygon, double radius, Mesh<CartesianPositionCoordinates, T> mesh) {
        HashSet<T> polys = new HashSet<T>();
        if (radius > 0.0) {
            polys.add(centerPolygon);
        }
        EList neighbours = mesh.getPolygonNeighbours(centerPolygon);
        Geometry3DUtilities.recursiveGetCartesianPolygonsPartiallyWithinRadius(polys, centerPolygon.getCentroid(), radius, mesh, neighbours);
        return polys;
    }

    private static <T extends CartesianPolygon> void recursiveGetCartesianPolygonsPartiallyWithinRadius(Set<T> polygonsFound, CartesianPositionCoordinates center, double radius, Mesh<CartesianPositionCoordinates, T> mesh, List<T> polygons) {
        int i = 0;
        while (i < polygons.size()) {
            CartesianPolygon polygon = (CartesianPolygon)polygons.get(i);
            if (!polygonsFound.contains(polygon) && Geometry3DUtilities.isPolygonPartiallyWithinRadius(center, radius, polygon)) {
                polygonsFound.add(polygon);
                EList neighbours = mesh.getPolygonNeighbours((Polygon)polygon);
                Geometry3DUtilities.recursiveGetCartesianPolygonsPartiallyWithinRadius(polygonsFound, center, radius, mesh, neighbours);
            }
            ++i;
        }
    }

    public static <T extends CartesianPolygon> boolean isPolygonPartiallyWithinRadius(CartesianPositionCoordinates centerPoint, double radius, T polygon) {
        Point3d center = centerPoint.asPoint3d();
        int i = 0;
        while (i < polygon.getVertices().size()) {
            if (((CartesianPositionCoordinates)polygon.getVertices().get(i)).asPoint3d().distance(center) < radius) {
                return true;
            }
            ++i;
        }
        if (polygon.getVertices().size() > 1) {
            i = 0;
            while (i < polygon.getVertices().size()) {
                CartesianPositionCoordinates p1 = null;
                CartesianPositionCoordinates p2 = null;
                if (i < polygon.getVertices().size() - 1) {
                    p1 = (CartesianPositionCoordinates)polygon.getVertices().get(i);
                    p2 = (CartesianPositionCoordinates)polygon.getVertices().get(i + 1);
                } else {
                    p1 = (CartesianPositionCoordinates)polygon.getVertices().get(i);
                    p2 = (CartesianPositionCoordinates)polygon.getVertices().get(0);
                }
                Point3d pIntersection = Geometry3DUtilities.getProjection(centerPoint, p1, p2).asPoint3d();
                if (pIntersection.distance(centerPoint.asPoint3d()) <= radius) {
                    Point3d p1Point = p1.asPoint3d();
                    Point3d p2Point = p2.asPoint3d();
                    double p1p2Distance = p1Point.distance(p2Point);
                    double p1pIntersectionDistance = p1Point.distance(pIntersection);
                    double p2pIntersectionDistance = p2Point.distance(pIntersection);
                    if (p1pIntersectionDistance < p1p2Distance && p2pIntersectionDistance < p1p2Distance) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static <T extends CartesianPolygon> boolean isPolygonWithinRadius(CartesianPositionCoordinates centerPoint, double radius, T polygon) {
        boolean isInside = true;
        Point3d center = centerPoint.asPoint3d();
        int i = 0;
        while (i < polygon.getVertices().size() && isInside) {
            CartesianPositionCoordinates vertex = (CartesianPositionCoordinates)polygon.getVertices().get(i);
            if (center.distance(vertex.asPoint3d()) > radius) {
                isInside = false;
                continue;
            }
            ++i;
        }
        return isInside;
    }

    public static <T1 extends Coordinates, T2 extends Polygon> Map<T1, List<T2>> getVertexToPolygonMapping(List<T2> polygons, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        HashMap vertexToPolygonMap = new HashMap();
        try {
            internalMonitor.beginTask(String.valueOf(Geometry3DUtilities.class.getSimpleName()) + ".getVertexToPolygonMapping", polygons.size());
            for (Polygon polygon : polygons) {
                for (Coordinates vertex : polygon.getVertices()) {
                    if (!vertexToPolygonMap.containsKey(vertex)) {
                        vertexToPolygonMap.put(vertex, new ArrayList());
                    }
                    if (((List)vertexToPolygonMap.get(vertex)).contains(polygon)) continue;
                    ((List)vertexToPolygonMap.get(vertex)).add(polygon);
                }
                internalMonitor.worked(1);
            }
        }
        finally {
            internalMonitor.done();
        }
        return vertexToPolygonMap;
    }

    public static Set<CartesianPositionCoordinates> getSharedVertices(List<CartesianPolygon> polygons) {
        HashSet<CartesianPositionCoordinates> sharedVertices = new HashSet<CartesianPositionCoordinates>();
        TreeMap<CartesianPositionCoordinates, Integer> vertexToPolygonCount = new TreeMap<CartesianPositionCoordinates, Integer>(new CartesianPositionCoordinatesDistanceComparator());
        for (CartesianPolygon polygon : polygons) {
            for (CartesianPositionCoordinates vertex : polygon.getVertices()) {
                if (vertexToPolygonCount.get(vertex) == null) {
                    vertexToPolygonCount.put(vertex, 0);
                }
                Integer count = new Integer((Integer)vertexToPolygonCount.get(vertex) + 1);
                vertexToPolygonCount.put(vertex, count);
            }
        }
        for (CartesianPositionCoordinates vertex : vertexToPolygonCount.keySet()) {
            Integer count = (Integer)vertexToPolygonCount.get(vertex);
            if (count.intValue() != polygons.size()) continue;
            sharedVertices.add(vertex);
        }
        return sharedVertices;
    }

    public static Set<CartesianPositionCoordinates> getSharedVertices(CartesianPolygon p1, CartesianPolygon p2) {
        ArrayList<CartesianPolygon> polygons = new ArrayList<CartesianPolygon>();
        polygons.add(p1);
        polygons.add(p2);
        return Geometry3DUtilities.getSharedVertices(polygons);
    }

    public static List<List<CartesianPositionCoordinates>> getDuplicateCartesianCoordinates(List<CartesianPositionCoordinates> coordinates) {
        ArrayList<List<CartesianPositionCoordinates>> duplicates = new ArrayList<List<CartesianPositionCoordinates>>();
        HashMap pointToEquivalent = new HashMap();
        for (CartesianPositionCoordinates point : coordinates) {
            boolean duplicateDetected = false;
            int i = 0;
            CartesianPositionCoordinates key = null;
            while (!duplicateDetected && i < pointToEquivalent.keySet().size()) {
                key = (CartesianPositionCoordinates)pointToEquivalent.keySet().toArray()[i];
                if (Geometry3DUtilities.getDistance(point, key) == 0.0) {
                    duplicateDetected = true;
                }
                ++i;
            }
            if (duplicateDetected) {
                ((List)pointToEquivalent.get(key)).add(point);
                continue;
            }
            ArrayList<CartesianPositionCoordinates> list = new ArrayList<CartesianPositionCoordinates>();
            list.add(point);
            pointToEquivalent.put(point, list);
        }
        for (List duplicatesList : pointToEquivalent.values()) {
            if (duplicatesList.size() <= 1) continue;
            duplicates.add(duplicatesList);
        }
        return duplicates;
    }

    public static CartesianCoordinatesMesh removeDuplicateVertex(CartesianCoordinatesMesh mesh) {
        CartesianCoordinatesMesh newMesh = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianCoordinatesMesh(mesh);
        Map vertexToPolygonMap = Geometry3DUtilities.getVertexToPolygonMapping(newMesh.getPolygons(), null);
        List<List<CartesianPositionCoordinates>> duplicatesVertex = Geometry3DUtilities.getDuplicateCartesianCoordinates((List<CartesianPositionCoordinates>)newMesh.getPoints());
        for (List<CartesianPositionCoordinates> duplicates : duplicatesVertex) {
            CartesianPositionCoordinates goodIncarnation = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(duplicates.get(0));
            newMesh.getPoints().add((Object)goodIncarnation);
            for (CartesianPositionCoordinates badPoint : duplicates) {
                List polygons = vertexToPolygonMap.get(badPoint);
                if (polygons == null) continue;
                int i = 0;
                while (i < polygons.size()) {
                    CartesianPolygon polygon = (CartesianPolygon)polygons.get(i);
                    int indexBadPoint = polygon.getVertices().indexOf((Object)badPoint);
                    polygon.getVertices().add(indexBadPoint, (Object)goodIncarnation);
                    polygon.getVertices().remove((Object)badPoint);
                    newMesh.getPolygons().remove((Object)polygon);
                    newMesh.getPolygons().add((Object)polygon);
                    ++i;
                }
            }
            Iterator<CartesianPositionCoordinates> badIt = duplicates.iterator();
            while (badIt.hasNext()) {
                newMesh.getPoints().remove((Object)badIt.next());
            }
        }
        return newMesh;
    }

    public static Set<CartesianPolygon> getPolygonVertexNeighbors(CartesianPolygon polygon, Map<CartesianPositionCoordinates, List<CartesianPolygon>> vertexToPolygonMap) {
        HashSet<CartesianPolygon> neighbours = new HashSet<CartesianPolygon>();
        for (CartesianPositionCoordinates vertex : polygon.getVertices()) {
            neighbours.addAll((Collection<CartesianPolygon>)vertexToPolygonMap.get(vertex));
        }
        neighbours.remove(polygon);
        return neighbours;
    }

    public static Set<CartesianPolygon> getPolygonVertexExtendedNeighbors(CartesianPolygon polygon, Map<CartesianPositionCoordinates, List<CartesianPolygon>> vertexToPolygonMap) {
        Set<Object> neighbours = new HashSet();
        HashSet<CartesianPolygon> processedPolygons = new HashSet<CartesianPolygon>();
        neighbours = Geometry3DUtilities.recursiveGetPolygonVertexExtendedNeighbors(processedPolygons, polygon, vertexToPolygonMap);
        neighbours.remove(polygon);
        return neighbours;
    }

    private static Set<CartesianPolygon> recursiveGetPolygonVertexExtendedNeighbors(Set<CartesianPolygon> processedPolygons, CartesianPolygon polygon, Map<CartesianPositionCoordinates, List<CartesianPolygon>> vertexToPolygonMap) {
        HashSet<CartesianPolygon> neighbours = new HashSet<CartesianPolygon>();
        Set<CartesianPolygon> immediateNeighbors = Geometry3DUtilities.getPolygonVertexNeighbors(polygon, vertexToPolygonMap);
        neighbours.addAll(immediateNeighbors);
        processedPolygons.add(polygon);
        for (CartesianPolygon p : immediateNeighbors) {
            if (processedPolygons.contains(p)) continue;
            processedPolygons.add(p);
            neighbours.addAll(Geometry3DUtilities.recursiveGetPolygonVertexExtendedNeighbors(processedPolygons, p, vertexToPolygonMap));
        }
        return neighbours;
    }

    public static Set<CartesianPolygon> getPolygonEdgeNeighbors(CartesianPolygon polygon, Map<CartesianPositionCoordinates, List<CartesianPolygon>> vertexToPolygonMap) {
        HashSet<CartesianPolygon> neighbours = new HashSet<CartesianPolygon>();
        for (CartesianPositionCoordinates vertex : polygon.getVertices()) {
            List<CartesianPolygon> potentialNeighbors = vertexToPolygonMap.get(vertex);
            for (CartesianPolygon potentialNeighbor : potentialNeighbors) {
                if (potentialNeighbor == polygon || Geometry3DUtilities.getSharedVertices(polygon, potentialNeighbor).size() <= 1) continue;
                neighbours.add(potentialNeighbor);
            }
        }
        return neighbours;
    }

    public static Set<CartesianPolygon> getPolygonEdgeExtendedNeighbors(CartesianPolygon polygon, Map<CartesianPositionCoordinates, List<CartesianPolygon>> vertexToPolygonMap) {
        Set<Object> neighbours = new HashSet();
        HashSet<CartesianPolygon> processedPolygons = new HashSet<CartesianPolygon>();
        neighbours = Geometry3DUtilities.recursiveGetPolygonEdgeExtendedNeighbors(processedPolygons, polygon, vertexToPolygonMap);
        neighbours.remove(polygon);
        return neighbours;
    }

    private static Set<CartesianPolygon> recursiveGetPolygonEdgeExtendedNeighbors(Set<CartesianPolygon> processedPolygons, CartesianPolygon polygon, Map<CartesianPositionCoordinates, List<CartesianPolygon>> vertexToPolygonMap) {
        HashSet<CartesianPolygon> neighbours = new HashSet<CartesianPolygon>();
        Set<CartesianPolygon> immediateNeighbors = Geometry3DUtilities.getPolygonEdgeNeighbors(polygon, vertexToPolygonMap);
        neighbours.addAll(immediateNeighbors);
        processedPolygons.add(polygon);
        for (CartesianPolygon p : immediateNeighbors) {
            if (processedPolygons.contains(p)) continue;
            processedPolygons.add(p);
            neighbours.addAll(Geometry3DUtilities.recursiveGetPolygonEdgeExtendedNeighbors(processedPolygons, p, vertexToPolygonMap));
        }
        return neighbours;
    }

    public static Set<Set<CartesianPolygon>> getCartesianPolygonGroupConnectedByVertex(List<CartesianPolygon> polygons, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        HashSet<Set<CartesianPolygon>> groups = new HashSet<Set<CartesianPolygon>>();
        try {
            internalMonitor.beginTask(String.valueOf(Geometry3DUtilities.class.getSimpleName()) + ".getCartesianPolygonGroupConnectedByVertex", polygons.size());
            Map<CartesianPositionCoordinates, List<CartesianPolygon>> map = Geometry3DUtilities.getVertexToPolygonMapping(polygons, monitor);
            for (CartesianPolygon polygon : polygons) {
                if (Geometry3DUtilities.getPolygonGroupForPolygon(groups, polygon) == null) {
                    HashSet<CartesianPolygon> group = new HashSet<CartesianPolygon>();
                    group.addAll(Geometry3DUtilities.getPolygonVertexExtendedNeighbors(polygon, map));
                    group.add(polygon);
                    groups.add(group);
                }
                internalMonitor.worked(1);
            }
        }
        finally {
            internalMonitor.done();
        }
        return groups;
    }

    public static Set<Set<CartesianPolygon>> getCartesianPolygonGroupsConnectedByEdge(List<CartesianPolygon> polygons, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        HashSet<Set<CartesianPolygon>> groups = new HashSet<Set<CartesianPolygon>>();
        try {
            internalMonitor.beginTask(String.valueOf(Geometry3DUtilities.class.getSimpleName()) + ".getCartesianPolygonGroupConnectedByEdge", polygons.size());
            Map<CartesianPositionCoordinates, List<CartesianPolygon>> map = Geometry3DUtilities.getVertexToPolygonMapping(polygons, monitor);
            for (CartesianPolygon polygon : polygons) {
                if (Geometry3DUtilities.getPolygonGroupForPolygon(groups, polygon) == null) {
                    HashSet<CartesianPolygon> group = new HashSet<CartesianPolygon>();
                    group.addAll(Geometry3DUtilities.getPolygonEdgeExtendedNeighbors(polygon, map));
                    group.add(polygon);
                    groups.add(group);
                }
                internalMonitor.worked(1);
            }
        }
        finally {
            internalMonitor.done();
        }
        return groups;
    }

    public static Set<CartesianPolygon> getPolygonGroupForPolygon(Set<Set<CartesianPolygon>> groups, CartesianPolygon polygon) {
        Set<CartesianPolygon> group = null;
        Iterator<Set<CartesianPolygon>> groupIt = groups.iterator();
        while (groupIt.hasNext() && group == null) {
            Set<CartesianPolygon> g = groupIt.next();
            if (!g.contains(polygon)) continue;
            group = g;
        }
        return group;
    }

    public static List<Point3d> getPoint3dList(List<CartesianPositionCoordinates> points) {
        ArrayList<Point3d> pointList = new ArrayList<Point3d>();
        for (CartesianPositionCoordinates p : points) {
            Point3d point = new Point3d(p.getX(), p.getY(), p.getZ());
            pointList.add(point);
        }
        return pointList;
    }

    public static List<CartesianPositionCoordinates> getCartesianPositionCoordinates(List<Point3d> points) {
        ArrayList<CartesianPositionCoordinates> pointList = new ArrayList<CartesianPositionCoordinates>();
        for (Point3d p : points) {
            CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(p.x, p.y, p.z);
            pointList.add(point);
        }
        return pointList;
    }

    public static CartesianPolygon createTransformedPolygon(Matrix4d transformationMatrix, CartesianPolygon polygon) {
        CartesianPolygon transformedData = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPolygon();
        List<Point3d> points = Geometry3DUtilities.getPoint3dList((List<CartesianPositionCoordinates>)polygon.getVertices());
        Geometry3DUtilities.applyTransformation(transformationMatrix, points);
        transformedData.getVertices().addAll(Geometry3DUtilities.getCartesianPositionCoordinates(points));
        return transformedData;
    }

    public static CartesianCoordinatesMesh createTransformedCartesianCoordinateMesh(Matrix4d transformationMatrix, CartesianCoordinatesMesh mesh) {
        CartesianCoordinatesMesh transformedMesh = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianCoordinatesMesh(mesh);
        List<Point3d> points = Geometry3DUtilities.getPoint3dList((List<CartesianPositionCoordinates>)mesh.getPoints());
        Geometry3DUtilities.applyTransformation(transformationMatrix, points);
        CartesianPositionCoordinates pos = null;
        Point3d point = null;
        int NP = points.size();
        int i = 0;
        while (i < NP) {
            pos = (CartesianPositionCoordinates)transformedMesh.getPoints().get(i);
            point = points.get(i);
            pos.setX(point.x);
            pos.setY(point.y);
            pos.setZ(point.z);
            ++i;
        }
        return transformedMesh;
    }

    public static CartesianCoordinatesSet createTransformedCartesianCoordinatesSet(Matrix4d transformationMatrix, CartesianCoordinatesSet cartesianCoordinatesSet) {
        CartesianCoordinatesSet result = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        List<Point3d> points = Geometry3DUtilities.getPoint3dList((List<CartesianPositionCoordinates>)cartesianCoordinatesSet.getPoints());
        Geometry3DUtilities.applyTransformation(transformationMatrix, points);
        for (Point3d point : points) {
            CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
            result.getPoints().add((Object)coord);
        }
        return result;
    }

    public static CartesianTriangularMesh createTransformedCartesianTriangularMesh(Matrix4d transformationMatrix, CartesianTriangularMesh mesh) {
        CartesianTriangularMesh transformedMesh = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangularMesh(mesh);
        List<Point3d> points = Geometry3DUtilities.getPoint3dList((List<CartesianPositionCoordinates>)mesh.getPoints());
        Geometry3DUtilities.applyTransformation(transformationMatrix, points);
        CartesianPositionCoordinates pos = null;
        Point3d point = null;
        int NP = points.size();
        int i = 0;
        while (i < NP) {
            pos = (CartesianPositionCoordinates)transformedMesh.getPoints().get(i);
            point = points.get(i);
            pos.setX(point.x);
            pos.setY(point.y);
            pos.setZ(point.z);
            ++i;
        }
        return transformedMesh;
    }

    public static CartesianPositionCoordinates createTransformedCartesianPositionCoordinates(Matrix4d transformationMatrix, CartesianPositionCoordinates coord) {
        Point3d point = new Point3d(coord.getX(), coord.getY(), coord.getZ());
        transformationMatrix.transform(point);
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
    }

    public static void applyTransformation(Matrix4d transformationMatrix, List<Point3d> points) {
        Iterator<Point3d> iterator = points.iterator();
        Point3d point = null;
        while (iterator.hasNext()) {
            point = iterator.next();
            transformationMatrix.transform(point);
        }
    }

    public static CartesianPolygon createNormalizedPolygonOfPlane(CartesianPlane plane) {
        CartesianAxis axis = Geometry3DUtilities.getPerpendicularAxis(plane);
        CartesianPositionCoordinates vO = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(0.0, 0.0, 0.0);
        CartesianPositionCoordinates vX = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(1.0, 0.0, 0.0);
        CartesianPositionCoordinates vY = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(0.0, 1.0, 0.0);
        CartesianPositionCoordinates vZ = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(0.0, 0.0, 1.0);
        CartesianPolygon polygon = null;
        switch (axis) {
            case X: {
                polygon = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPolygon(vO, vY, vZ);
                break;
            }
            case Y: {
                polygon = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPolygon(vO, vZ, vX);
                break;
            }
            case Z: {
                polygon = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPolygon(vO, vX, vY);
                break;
            }
        }
        return polygon;
    }

    public static CartesianCoordinatesSetExtent getCartesianCoordinatesSetExtent(List<CartesianPositionCoordinates> points) {
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        double zMin = Double.POSITIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        for (CartesianPositionCoordinates p : points) {
            if (p.getX() < xMin) {
                xMin = p.getX();
            }
            if (p.getX() > xMax) {
                xMax = p.getX();
            }
            if (p.getY() < yMin) {
                yMin = p.getY();
            }
            if (p.getY() > yMax) {
                yMax = p.getY();
            }
            if (p.getZ() < zMin) {
                zMin = p.getZ();
            }
            if (!(p.getZ() > zMax)) continue;
            zMax = p.getZ();
        }
        CartesianCoordinatesSetExtent extent = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSetExtent();
        extent.setXMin(xMin);
        extent.setXMax(xMax);
        extent.setYMin(yMin);
        extent.setYMax(yMax);
        extent.setZMin(zMin);
        extent.setZMax(zMax);
        return extent;
    }

    public static Vector3d getAreaWeightedAverageNormal(List<CartesianTriangle> triangles) {
        Vector3d normal = new Vector3d();
        for (CartesianTriangle triangle : triangles) {
            Vector3d triangleEffectiveNormal = triangle.getNormal();
            triangleEffectiveNormal.scale(triangle.getSurface());
            normal.add((Tuple3d)triangleEffectiveNormal);
        }
        normal.normalize();
        return normal;
    }

    public static <T extends Coordinates> Map<T, Integer> createPointIdMap(CoordinatesSet<T> coordinateSet) {
        HashMap<Coordinates, Integer> map = new HashMap<Coordinates, Integer>();
        int i = 0;
        while (i < coordinateSet.getPoints().size()) {
            map.put((Coordinates)coordinateSet.getPoints().get(i), new Integer(i));
            ++i;
        }
        return map;
    }

    public static class CartesianPolygonCoordinatesDistanceComparator
    implements Comparator<CartesianPolygon> {
        private CartesianPositionCoordinates centerPoint = null;
        private final CoordinatesComparator coordinatesComparator = new CoordinatesComparator();

        public CartesianPolygonCoordinatesDistanceComparator(CartesianPositionCoordinates centerPoint) {
            this.centerPoint = centerPoint;
        }

        @Override
        public int compare(CartesianPolygon o1, CartesianPolygon o2) {
            CartesianPositionCoordinates c2;
            double d2;
            CartesianPositionCoordinates c1 = Geometry3DUtilities.getCentroid((List<CartesianPositionCoordinates>)o1.getVertices());
            double d1 = Geometry3DUtilities.getDistance(c1, this.centerPoint);
            if (d1 > (d2 = Geometry3DUtilities.getDistance(c2 = Geometry3DUtilities.getCentroid((List<CartesianPositionCoordinates>)o2.getVertices()), this.centerPoint))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return this.coordinatesComparator.compare(c1, c2);
        }
    }

    public static class CartesianPositionCoordinatesDistanceComparator
    implements Comparator<CartesianPositionCoordinates> {
        private CartesianPositionCoordinates centerPoint = null;
        private final CoordinatesComparator coordinatesComparator = new CoordinatesComparator();

        public CartesianPositionCoordinatesDistanceComparator() {
            this(ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates());
        }

        public CartesianPositionCoordinatesDistanceComparator(CartesianPositionCoordinates centerPoint) {
            this.centerPoint = centerPoint;
        }

        @Override
        public int compare(CartesianPositionCoordinates o1, CartesianPositionCoordinates o2) {
            double d2;
            double d1 = Geometry3DUtilities.getDistance(o1, this.centerPoint);
            if (d1 > (d2 = Geometry3DUtilities.getDistance(o2, this.centerPoint))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return this.coordinatesComparator.compare(o1, o2);
        }
    }

    private static class CoordinatesComparator
    implements Comparator<CartesianPositionCoordinates> {
        private CoordinatesComparator() {
        }

        @Override
        public int compare(CartesianPositionCoordinates o1, CartesianPositionCoordinates o2) {
            double deltax = o1.getX() - o2.getX();
            if (deltax > 0.0) {
                return 1;
            }
            if (deltax < 0.0) {
                return -1;
            }
            double deltay = o1.getY() - o2.getY();
            if (deltay > 0.0) {
                return 1;
            }
            if (deltay < 0.0) {
                return -1;
            }
            double deltaz = o1.getZ() - o2.getZ();
            if (deltaz > 0.0) {
                return 1;
            }
            if (deltaz < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

