/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui.renderers;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BufferedImageSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private BufferedImage bufferedImage;
    private ImageData imageData;

    @Inject
    public BufferedImageSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        IFileExporter iFileExporter;
        final Composite top = new Composite(parent, 2048);
        top.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(top, 0);
        label.setBackground(Display.getCurrent().getSystemColor(37));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bufferedImage = this.getValue();
        if (this.bufferedImage != null) {
            this.imageData = EImagesUtilities.INSTANCE.convertToImageData(this.bufferedImage);
        }
        if (this.imageData != null) {
            ImageData displayedImageData = (ImageData)this.imageData.clone();
            Image image = new Image((Device)Display.getCurrent(), displayedImageData);
            label.setImage(image);
        }
        if ((iFileExporter = ApogyCommonConvertersFacade.INSTANCE.getIFileExporter((Object)this.bufferedImage)) != null) {
            Button exportButton = new Button(top, 8);
            exportButton.setText("Export Image To File...");
            exportButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExportToFileWizard wizard = new ExportToFileWizard(iFileExporter, (Object)BufferedImageSWTRenderer.this.bufferedImage);
                    WizardDialog dialog = new WizardDialog(top.getShell(), (IWizard)wizard);
                    dialog.open();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
        return top;
    }

    protected String getUnsetText() {
        return "Unset";
    }

    protected BufferedImage getValue() {
        try {
            Object obj = this.getModelValue().getValue();
            if (obj instanceof BufferedImage) {
                return (BufferedImage)obj;
            }
            return null;
        }
        catch (DatabindingFailedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

