/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.converters;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.images.converters.AbstractEImageToFileConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedImageToFileConverter
implements IFileExporter {
    public static final String JPEG_FILE_EXTENSION = "jpg";
    public static final String PNG_FILE_EXTENSION = "png";
    private static final Logger Logger = LoggerFactory.getLogger(AbstractEImageToFileConverter.class);

    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return BufferedImage.class;
    }

    public boolean canConvert(Object input) {
        return input instanceof BufferedImage;
    }

    public Object convert(Object input) throws Exception {
        BufferedImage bufferedImage = (BufferedImage)input;
        String tmpFolder = String.valueOf(System.getProperty("user.home")) + File.separator + System.getProperty("java.io.tmpdir");
        Date now = new Date();
        String fileName = null;
        try {
            fileName = String.valueOf(tmpFolder) + File.separator + now.getTime() + "." + JPEG_FILE_EXTENSION;
            File file = new File(fileName);
            ImageIO.write((RenderedImage)bufferedImage, JPEG_FILE_EXTENSION, file);
            return new File(fileName);
        }
        catch (Exception e) {
            File toDelete = new File(fileName);
            toDelete.delete();
            Logger.error("could not create temporary file <" + fileName + "> !", (Throwable)e);
            return null;
        }
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        BufferedImage bufferedImage = (BufferedImage)input;
        for (String extension : extensions) {
            File file;
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (extension.equalsIgnoreCase(JPEG_FILE_EXTENSION)) {
                file = new File(fullPathString);
                ImageIO.write((RenderedImage)bufferedImage, JPEG_FILE_EXTENSION, file);
                continue;
            }
            if (!extension.equalsIgnoreCase(PNG_FILE_EXTENSION)) continue;
            file = new File(fullPathString);
            ImageIO.write((RenderedImage)bufferedImage, PNG_FILE_EXTENSION, file);
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(JPEG_FILE_EXTENSION);
        extensions.add(PNG_FILE_EXTENSION);
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains(JPEG_FILE_EXTENSION)) {
            return "Image file in JPEG format.";
        }
        if (fileExtension.contains(PNG_FILE_EXTENSION)) {
            return "Image file in PNG format.";
        }
        return null;
    }
}

