/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.apogy.common.ui.impl.ApogyCommonUiFacadeImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonUiFacadeCustomImpl
extends ApogyCommonUiFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonUiFacadeImpl.class);

    @Override
    public ImageDescriptor getImageDescriptor(String uri) {
        ImageDescriptor imageDescriptor = null;
        try {
            URL url = new URL(uri);
            imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            Logger.warn("Unable to load image <" + uri + ">", (Throwable)e);
        }
        return imageDescriptor;
    }

    @Override
    public void adjustWizardPage(WizardPage wizardPage, Double ratio) {
        Monitor[] monitorArray = wizardPage.getShell().getDisplay().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            if (monitor.getBounds().contains(wizardPage.getShell().getDisplay().getCursorLocation())) {
                wizardPage.getShell().setSize(new Double((double)monitor.getBounds().width * ratio).intValue(), new Double((double)monitor.getBounds().height * ratio).intValue());
                wizardPage.getShell().setLocation(monitor.getBounds().x + (monitor.getBounds().width - wizardPage.getShell().getBounds().width) / 2, monitor.getBounds().y + (monitor.getBounds().height - wizardPage.getShell().getBounds().height) / 2);
            }
            ++n2;
        }
        if (wizardPage.getControl() instanceof Composite) {
            wizardPage.getControl().requestLayout();
        }
    }

    @Override
    public void addExpandOnDoubleClick(final TreeViewer treeViewer) {
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (treeViewer.getExpandedState(selectedObject)) {
                    treeViewer.collapseToLevel(selectedObject, -1);
                } else {
                    treeViewer.expandToLevel(selectedObject, 1);
                }
                TreeColumn[] treeColumnArray = treeViewer.getTree().getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn treeColumn = treeColumnArray[n2];
                    treeColumn.pack();
                    ++n2;
                }
            }
        });
        treeViewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event e) {
                TreeItem treeItem = (TreeItem)e.item;
                final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeColumns;
                        int n = treeColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                });
            }
        });
    }
}

