/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.widgets.ui;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.apogy.common.widgets.ui.Range;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThermometerComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ThermometerComposite.class);
    private static final String IMAGES_FOLDER = "platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/";
    private Image backgroundMeter;
    private Image needle;
    private final double minValue;
    private final double maxValue;
    private final double intervalValue;
    private double actualValue;
    private final String unit;
    private final String title;
    private final ArrayList<Range> ranges = new ArrayList();
    private DecimalFormat numberFormat;
    private DecimalFormat actualValueFormat;
    private Color unitColor;
    private Color titleColor;
    private Color numbersColor;
    private Color actualValueColor;

    public ThermometerComposite(Composite parent, int style, double min, double max, double intervalValue, double initialValue, String unit, String title) {
        super(parent, style | 0x20000000);
        this.minValue = min;
        this.maxValue = max;
        this.actualValue = initialValue;
        this.intervalValue = intervalValue;
        this.unit = unit;
        this.title = title;
        this.initColors();
        this.initFormats();
        this.initImages();
        this.createPaintListener();
        this.createDisposeListener();
    }

    public void addRange(double min, double max, Color c) {
        Range newRange = new Range(min, max, c);
        this.ranges.add(newRange);
        Collections.sort(this.ranges);
        this.redraw();
    }

    public void clearRanges() {
        this.ranges.clear();
        this.redraw();
    }

    public synchronized double getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(double actualValue) {
        this.actualValue = actualValue;
        this.redraw();
    }

    public void setActualValueFormat(DecimalFormat avf) {
        this.actualValueFormat = avf;
    }

    public void setNumberFormat(DecimalFormat nf) {
        this.numberFormat = nf;
    }

    private void initImages() {
        try {
            Display device = Display.getCurrent();
            URL url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/tempFrame.png");
            this.backgroundMeter = new Image((Device)device, url.openStream());
            url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/aiguille2.png");
            this.needle = new Image((Device)device, url.openStream());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void paintMeter(GC gc) {
        Color color;
        float XScaleFactor = 0.0f;
        float YScaleFactor = 0.0f;
        if (this.backgroundMeter != null) {
            XScaleFactor = (float)this.getBounds().width / (float)this.backgroundMeter.getBounds().width;
            YScaleFactor = (float)this.getBounds().height / (float)this.backgroundMeter.getBounds().height;
        }
        int centerXMeter = this.getBounds().width / 2;
        int centerYMeter = this.getBounds().height / 2;
        int xRect = centerXMeter - Math.round(10.0f * XScaleFactor);
        int yRect = Math.round(25.0f * YScaleFactor);
        int widthRect = Math.round(20.0f * XScaleFactor);
        int heightRect = 2 * centerYMeter - Math.round(50.0f * YScaleFactor);
        if (this.backgroundMeter != null) {
            gc.drawImage(this.backgroundMeter, 0, 0, this.backgroundMeter.getBounds().width, this.backgroundMeter.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        } else {
            color = new Color((Device)this.getDisplay(), 0, 0, 0);
            gc.setForeground(color);
            gc.setLineWidth(4);
            gc.drawRectangle(2, 2, this.getBounds().width - 4, this.getBounds().height - 4);
            color.dispose();
        }
        for (Range r : this.ranges) {
            gc.setBackground(r.getColor());
            int minRangeValue = (int)((double)yRect + (this.maxValue - r.getMinimum()) / (this.maxValue - this.minValue) * (double)heightRect);
            int maxRangeValue = (int)((double)yRect + (this.maxValue - r.getMaximum()) / (this.maxValue - this.minValue) * (double)heightRect);
            gc.fillRectangle(centerXMeter - Math.round(10.0f * XScaleFactor), minRangeValue, Math.round(20.0f * XScaleFactor), maxRangeValue - minRangeValue);
        }
        color = new Color((Device)this.getDisplay(), 51, 118, 0);
        gc.setForeground(color);
        gc.setLineWidth(3);
        gc.drawRectangle(xRect, yRect, widthRect, heightRect);
        color.dispose();
        int nbDraw = (int)Math.round((this.maxValue - this.minValue) / this.intervalValue);
        double drawingNumber = this.minValue;
        int size = Math.round(6.0f * XScaleFactor);
        Font font = new Font((Device)this.getDisplay(), "Tahoma", size, 1);
        gc.setFont(font);
        int i = nbDraw;
        while (i >= 0) {
            color = new Color((Device)this.getDisplay(), 51, 118, 0);
            gc.setForeground(color);
            int x1Line = xRect;
            int y1Line = Math.round((float)yRect + (float)i / (float)nbDraw * (float)heightRect);
            int x2Line = xRect - 5;
            int y2Line = y1Line;
            gc.drawLine(x1Line, y1Line, x2Line, y2Line);
            color.dispose();
            gc.setForeground(this.numbersColor);
            int widthOfNumber = (int)(gc.getFontMetrics().getAverageCharacterWidth() * (double)(String.valueOf(this.numberFormat.format(drawingNumber)) + "  ").length());
            int heightOfNumber = gc.getFontMetrics().getHeight() / 2;
            gc.drawString(String.valueOf(this.numberFormat.format(drawingNumber)) + "  ", x2Line - widthOfNumber, y1Line - heightOfNumber, true);
            drawingNumber += this.intervalValue;
            --i;
        }
        font.dispose();
        float textSize = 5.6f;
        size = Math.round(textSize * XScaleFactor);
        font = new Font((Device)this.getDisplay(), "Tahoma", size, 1);
        gc.setFont(font);
        gc.setForeground(this.titleColor);
        int widthOfNumber = 0;
        int i2 = 0;
        while (i2 < this.title.length()) {
            widthOfNumber += gc.getAdvanceWidth(this.title.charAt(i2));
            ++i2;
        }
        gc.drawString(this.title, centerXMeter - widthOfNumber / 2, yRect + heightRect + Math.round(textSize * YScaleFactor), true);
        widthOfNumber = 0;
        i2 = 0;
        while (i2 < this.unit.length()) {
            widthOfNumber += gc.getAdvanceWidth(this.unit.charAt(i2));
            ++i2;
        }
        int heightOfNumber = gc.getFontMetrics().getHeight();
        gc.setForeground(this.unitColor);
        gc.drawString(this.unit, centerXMeter - widthOfNumber / 2, yRect - (heightOfNumber + 5), true);
        font.dispose();
        int yPosNeedle = 0;
        if (this.needle != null) {
            yPosNeedle = (int)((double)(yRect - Math.round((float)(this.needle.getBounds().height / 2) * YScaleFactor)) + (this.maxValue - this.actualValue) / (this.maxValue - this.minValue) * (double)heightRect);
            gc.drawImage(this.needle, 0, 0, this.needle.getBounds().width, this.needle.getBounds().height, centerXMeter, yPosNeedle, Math.round((float)this.needle.getBounds().width * XScaleFactor), Math.round((float)this.needle.getBounds().height * YScaleFactor));
        }
        gc.setForeground(this.actualValueColor);
        size = Math.round(6.0f * XScaleFactor);
        font = new Font((Device)this.getDisplay(), "Tahoma", size, 1);
        gc.setFont(font);
        heightOfNumber = gc.getFontMetrics().getHeight();
        widthOfNumber = (int)(gc.getFontMetrics().getAverageCharacterWidth() * (double)this.actualValueFormat.format(this.actualValue).length());
        int xPosNumber = 0;
        int yPosNumber = 0;
        if (this.needle != null) {
            xPosNumber = centerXMeter + (Math.round((float)(this.needle.getBounds().width / 2) * XScaleFactor) - widthOfNumber / 2) + Math.round(9.0f * XScaleFactor);
            yPosNumber = yPosNeedle + Math.round((float)this.needle.getBounds().height * YScaleFactor) / 2 - heightOfNumber / 2;
        }
        gc.drawString(this.actualValueFormat.format(this.actualValue), xPosNumber, yPosNumber, true);
        font.dispose();
    }

    private void initColors() {
        this.numbersColor = new Color((Device)Display.getCurrent(), 41, 225, 46);
        this.titleColor = new Color((Device)this.getDisplay(), 51, 118, 0);
        this.unitColor = new Color((Device)this.getDisplay(), 51, 118, 0);
        this.actualValueColor = new Color((Device)Display.getCurrent(), 41, 225, 46);
    }

    private void initFormats() {
        this.numberFormat = new DecimalFormat("##");
        this.actualValueFormat = new DecimalFormat("##");
    }

    private void createPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ThermometerComposite.this.paintMeter(e.gc);
            }
        });
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ThermometerComposite.this.backgroundMeter != null) {
                    ThermometerComposite.this.backgroundMeter.dispose();
                }
                if (ThermometerComposite.this.needle != null) {
                    ThermometerComposite.this.needle.dispose();
                }
            }
        });
    }
}

