/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lander.impl;

import java.text.DecimalFormat;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.examples.lander.ApogyExamplesLanderFactory;
import org.eclipse.apogy.examples.lander.Position;
import org.eclipse.apogy.examples.lander.impl.LanderSimulatedImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LanderSimulatedFlyingJob
extends Job {
    private static final Logger Logger = LoggerFactory.getLogger(LanderSimulatedFlyingJob.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("#####0.000");
    private static final int SIMULATION_WAIT_PERIOD = 50;
    static final double GROUND_Z = 0.0;
    private final LanderSimulatedImpl lander;
    private boolean shouldLog;

    public LanderSimulatedFlyingJob(LanderSimulatedImpl lander, String jobName) {
        super(jobName);
        this.lander = lander;
        this.shouldLog = false;
    }

    public void shouldLog(boolean logStateChanges) {
        this.shouldLog = logStateChanges;
    }

    protected IStatus run(IProgressMonitor monitor) {
        long lastTime = -1L;
        Vector3d previousVelocity = new Vector3d();
        if (this.shouldLog) {
            Logger.info("The lander's flying simulation has started");
        }
        while (!monitor.isCanceled() || this.lander.getPosition().getZ() > 0.0) {
            if (lastTime < 0L) {
                lastTime = System.currentTimeMillis();
            } else if (!this.lander.isChangingAttitude() && !this.lander.isChangingLocation()) {
                long currentTime = System.currentTimeMillis();
                double deltaT = (double)(currentTime - lastTime) * 0.001;
                Vector3d newCoords = new Vector3d(this.lander.getPosition().getX(), this.lander.getPosition().getY(), this.lander.getPosition().getZ());
                Matrix3d newAttitude = new Matrix3d(this.lander.getPosition().getAttitude());
                double fuelFlowRate = this.lander.getThruster().getCurrentThrust() / 2158.2000000000003;
                double deltaFuel = deltaT * fuelFlowRate;
                this.lander.setFuelMass(this.lander.getFuelMass() - deltaFuel);
                if (this.lander.getFuelMass() < 0.0) {
                    this.lander.setFuelMass(0.0);
                }
                if (this.lander.getFuelMass() == 0.0) {
                    this.lander.getThruster().setCurrentThrust(0.0);
                }
                Vector3d thrust = new Vector3d(0.0, 0.0, this.lander.getThruster().getCurrentThrust());
                newAttitude.transform((Tuple3d)thrust);
                Vector3d gravity = new Vector3d(0.0, 0.0, this.lander.getGravitationalPull());
                Vector3d acceleration = new Vector3d(thrust);
                acceleration.add((Tuple3d)gravity);
                acceleration.scale(1.0 / this.lander.getMass());
                Vector3d deltaV = new Vector3d(acceleration);
                deltaV.scale(deltaT);
                Vector3d newVelocity = new Vector3d(previousVelocity);
                newVelocity.add((Tuple3d)deltaV);
                previousVelocity = newVelocity;
                Vector3d displacement = new Vector3d(newVelocity);
                displacement.scale(0.5 * deltaT);
                newCoords.add((Tuple3d)displacement);
                if (newCoords.getZ() < 0.0) {
                    if (this.shouldLog) {
                        Logger.info("The calculated Z value (" + decimalFormat.format(newCoords.getZ()) + ") is less than the minimum allowed Z value (" + decimalFormat.format(0.0) + "); using the " + "minimum allowed Z value instead.");
                    }
                    newCoords.setZ(0.0);
                    newVelocity.setZ(0.0);
                }
                Matrix3d xRot = new Matrix3d();
                xRot.setIdentity();
                xRot.rotX(this.lander.getXAngularVelocity() * deltaT);
                Matrix3d yRot = new Matrix3d();
                yRot.setIdentity();
                yRot.rotY(this.lander.getYAngularVelocity() * deltaT);
                newAttitude.mul(xRot);
                newAttitude.mul(yRot);
                Position newPosition = ApogyExamplesLanderFactory.eINSTANCE.createPosition();
                newPosition.setX(newCoords.getX());
                newPosition.setY(newCoords.getY());
                newPosition.setZ(newCoords.getZ());
                newPosition.setAttitude(newAttitude);
                this.lander.setPosition(newPosition);
                lastTime = currentTime;
                if (this.shouldLog) {
                    Logger.info("Lander State Update");
                    Logger.info("Current Acceleration (in m/s^2): X=" + decimalFormat.format(acceleration.getX()) + ", Y=" + decimalFormat.format(acceleration.getY()) + ", Z=" + decimalFormat.format(acceleration.getZ()));
                    Logger.info("Current Velocity (in m/s): X=" + decimalFormat.format(newVelocity.getX()) + ", Y=" + decimalFormat.format(newVelocity.getY()) + ", Z=" + decimalFormat.format(newVelocity.getZ()));
                    Logger.info("Current Position (in m): X=" + decimalFormat.format(newPosition.getX()) + ", Y=" + decimalFormat.format(newPosition.getY()) + ", Z=" + decimalFormat.format(newPosition.getZ()));
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.shouldLog) {
            Logger.info("The lander's flying simulation has completed.");
        }
        return Status.OK_STATUS;
    }
}

