/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.rover.impl;

import org.eclipse.apogy.examples.rover.impl.RoverSimulatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverSimulatedCustomImpl
extends RoverSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(RoverSimulatedImpl.class);
    private static final String DEGREE_SYM = "\u00b0";

    @Override
    public boolean init() {
        if (this.isDisposed()) {
            Logger.warn("Rejected; the rover has already been disposed.");
            return false;
        }
        if (this.isInitialized()) {
            Logger.warn("Ignored; The rover has already been successfully initialized.");
            return true;
        }
        Logger.info("Rover initialization started.");
        this.getMobilePlatform().init();
        this.getIntegratedRoboticArm().init();
        this.getCenterCamera().init();
        Logger.info("Rover initialization completed.");
        this.setInitialized(true);
        return true;
    }

    @Override
    public void dispose() {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".dispose(): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Ignored; the rover has already " + "been disposed.";
            throw new RuntimeException(message);
        }
        Logger.info("Rover disposal started.");
        if (this.getMobilePlatform() != null) {
            this.getMobilePlatform().dispose();
        }
        this.setDisposed(true);
        Logger.info("Rover disposal completed.");
    }

    @Override
    public void cmdLinearVelocity(double linearVelocity) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".cmdLinearVelocity(" + linearVelocity + "): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the rover has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the rover has not been " + "successfully initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.getMobilePlatform().cmdLinearVelocity(linearVelocity);
    }

    @Override
    public void cmdAngularVelocity(double angularVelocity) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".cmdAngularVelocity(" + Math.toDegrees(angularVelocity) + " (" + DEGREE_SYM + "/s)): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the rover has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the rover has not been " + "successfully initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.getMobilePlatform().cmdAngularVelocity(angularVelocity);
    }

    @Override
    public void cmdVelocities(double linearVelocity, double angularVelocity) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".cmdVelocities(" + linearVelocity + " , " + Math.toDegrees(angularVelocity) + " (" + DEGREE_SYM + "/s)): ";
        if (this.isDisposed()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the rover has already " + "been disposed (with dispose()).";
            throw new RuntimeException(message);
        }
        if (!this.isInitialized()) {
            String message = String.valueOf(LOG_PREFIX) + "Rejected; the rover has not been successfully initialized (with init()).";
            throw new RuntimeException(message);
        }
        this.getMobilePlatform().cmdVelocities(linearVelocity, angularVelocity);
    }

    @Override
    public void cmdChangeName(String name) {
        this.setName(name);
    }
}

